/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.timelines.AbstractTimelinesService;
import com.dataiku.dip.timelines.ProjectTimelineBehavior;
import com.dataiku.dip.timelines.ProjectTimelineInternalDB;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Striped;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;

public class MultiTimelinesInternalDB
extends AbstractTimelinesService {
    private static Map<String, ProjectTimelineInternalDB> projectDAOs = new ConcurrentHashMap<String, ProjectTimelineInternalDB>();
    private static AtomicLong timelinesInitTime = new AtomicLong(0L);
    private static AtomicLong initializedTimelines = new AtomicLong(0L);
    private Striped<Lock> locks = Striped.lock((int)100);
    private static DKULogger logger = DKULogger.getLogger((String)"dku.timelines");

    @Override
    public DSSDBConnection acquireConnection(String projectKey, boolean isReadOnly) throws CodedSQLException {
        return this.getProjectDao(projectKey).acquireConnection(isReadOnly);
    }

    @Override
    public void createProject(String projectKey) throws CodedSQLException {
        this.getDao(projectKey);
    }

    public static File getProjectDAOFile(String projectKey) {
        return new File(ApplicationConfigurator.getBaseFolderF(), "timelines/" + projectKey);
    }

    @Override
    public void deleteForProject(String projectKey) {
        try {
            this.getProjectDao(projectKey).deleteConnectionPool();
        }
        catch (CodedSQLException e) {
            logger.errorV((Throwable)e, "Could not delete connections pool for %s", new Object[]{projectKey});
        }
        projectDAOs.remove(projectKey);
        try {
            File pageStoreFile = new File(String.valueOf(MultiTimelinesInternalDB.getProjectDAOFile(projectKey).getAbsoluteFile()) + ".h2.db");
            File mvStoreFile = new File(String.valueOf(MultiTimelinesInternalDB.getProjectDAOFile(projectKey).getAbsoluteFile()) + ".mv.db");
            if (pageStoreFile.exists()) {
                DKUFileUtils.forceDelete((File)pageStoreFile);
            } else if (mvStoreFile.exists()) {
                DKUFileUtils.forceDelete((File)mvStoreFile);
            } else {
                logger.warn((Object)"Timelines db not backed by a file with expected extension, or missing.");
            }
            if (MultiTimelinesInternalDB.getProjectDAOFile(projectKey).exists()) {
                throw new RuntimeException("Project timeline file still exists");
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to delete project timeline file: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            DKUFileUtils.forceDelete((File)new File(String.valueOf(MultiTimelinesInternalDB.getProjectDAOFile(projectKey).getAbsoluteFile()) + ".trace.db"));
            if (MultiTimelinesInternalDB.getProjectDAOFile(projectKey).exists()) {
                throw new RuntimeException("Project timeline file still exists");
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to delete project timeline file: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    @Override
    public ProjectTimelineBehavior getDao(String projectKey) throws CodedSQLException {
        return this.getProjectDao((String)projectKey).behavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectTimelineInternalDB getProjectDao(String projectKey) throws CodedSQLException {
        Lock l = (Lock)this.locks.get((Object)projectKey);
        l.lock();
        try {
            if (projectDAOs.containsKey(projectKey)) {
                ProjectTimelineInternalDB projectTimelineInternalDB = projectDAOs.get(projectKey);
                return projectTimelineInternalDB;
            }
            long count = initializedTimelines.incrementAndGet();
            Stopwatch sw = Stopwatch.createStarted();
            logger.info((Object)("Create timelines for project " + projectKey));
            ProjectTimelineInternalDB dao = new ProjectTimelineInternalDB(projectKey);
            dao.create();
            try (DSSDBConnection connection = dao.acquireConnection();){
                dao.behavior.fetchInitialUIData(connection);
            }
            projectDAOs.put(projectKey, dao);
            long time = timelinesInitTime.addAndGet(sw.elapsed(TimeUnit.MILLISECONDS));
            logger.info((Object)("Timelines init time: " + time + "ms (" + count + " timelines)"));
            ProjectTimelineInternalDB projectTimelineInternalDB = dao;
            return projectTimelineInternalDB;
        }
        finally {
            l.unlock();
        }
    }
}

