/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.utils.DKULogger;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DKUExecutors {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.executors");

    public static ScheduledExecutorService newNamedSingleDaemonThreadExecutor(String name) {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(name + "-%d").setDaemon(true).build());
    }

    public static class DKUExecutor
    implements Closeable {
        private final ExecutorService executorService;
        private final List<Future<?>> futures = new ArrayList();
        private final int shutdownWaitMs;
        private final String name;

        public DKUExecutor(int poolSize, String name, String nameFormat, int shutdownWait) {
            this.executorService = Executors.newFixedThreadPool(poolSize, new ThreadFactoryBuilder().setNameFormat(nameFormat).build());
            this.shutdownWaitMs = shutdownWait;
            this.name = name;
        }

        public synchronized Future<?> submit(Runnable r) {
            Future<?> f = this.executorService.submit(r);
            this.futures.add(f);
            return f;
        }

        public synchronized Future<?> submit(Callable<?> r) {
            Future<?> f = this.executorService.submit(r);
            this.futures.add(f);
            return f;
        }

        public synchronized void waitFutures() {
            ArrayList futuresToRemove = new ArrayList();
            for (Future<?> f : this.futures) {
                if (f == null) continue;
                try {
                    if (!f.isCancelled()) {
                        f.get();
                    }
                    futuresToRemove.add(f);
                }
                catch (InterruptedException | ExecutionException e) {
                    this.futures.removeAll(futuresToRemove);
                    this.futures.remove(f);
                    throw new RuntimeException(e);
                }
            }
            this.futures.clear();
        }

        public synchronized void shutdownAndWait() {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(this.shutdownWaitMs, TimeUnit.MILLISECONDS)) {
                    logger.warnV("Executor termination reached after %d ms for %s", new Object[]{this.shutdownWaitMs, this.name});
                    this.executorService.shutdownNow();
                    for (Future<?> f : this.futures) {
                        f.cancel(true);
                        logger.warnV("Canceled future: %s for %s", new Object[]{f, this.name});
                    }
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            this.waitFutures();
        }

        @Override
        public void close() {
            this.shutdownAndWait();
        }
    }
}

