/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.webapps.backend.WebAppRun;
import com.dataiku.dip.webapps.backend.WebAppRunContext;
import java.io.IOException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class PerWebAppLoggingAppender
extends AppenderSkeleton {
    private final WebAppRunContext webAppRunContext;

    public PerWebAppLoggingAppender(WebAppRunContext webAppRunContext) {
        this.webAppRunContext = webAppRunContext;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        String[] s;
        WebAppRun webAppRun = this.webAppRunContext.getWebAppRun();
        if (webAppRun == null) {
            return;
        }
        String data = this.layout.format(event);
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            StringBuilder dataBuilder = new StringBuilder(data);
            for (int i = 0; i < s.length; ++i) {
                dataBuilder.append(s[i]);
                dataBuilder.append(Layout.LINE_SEP);
            }
            data = dataBuilder.toString();
        }
        try {
            DKUtils.RotatingAttachableLoggingSubscription log = webAppRun.getOrCreateRotatingLog("webapp.log");
            log.handleNoNewline(data, true);
        }
        catch (IOException e) {
            System.out.println("Failed to log per-webapp run line: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

