/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.streamlit;

import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.streamlit.AbstractStreamlitWebAppHandler;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StreamlitWebAppHandler
extends AbstractStreamlitWebAppHandler {
    private final RelFile directory;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.webapps.streamlit");

    public StreamlitWebAppHandler(WebApp webapp) {
        super(webapp);
        this.directory = new RelFile(new String[]{"projects", webapp.projectKey, "web_apps", webapp.id});
    }

    @Override
    public void readCodeFiles() {
        try {
            RelFile configFile;
            TransactionRef t = TransactionContext.retrieveRead();
            RelFile pythonFile = this.getMainPythonRelFile(this.directory);
            if (t.isFile(pythonFile)) {
                this.params.python = t.readStringUTF8(pythonFile);
            }
            if (t.isFile(configFile = this.getConfigRelFile(this.directory))) {
                this.params.config = t.readStringUTF8(configFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read web app from " + this.directory.getFullPath(), e);
        }
    }

    @Override
    public void writeCodeFiles() throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (this.params.isBackendEnabled()) {
            if (this.params.python != null) {
                t.writeStringUTF8(this.getMainPythonRelFile(this.directory), this.params.python);
            }
            if (this.params.config != null) {
                t.writeStringUTF8(this.getConfigRelFile(this.directory), this.params.config);
            }
        }
    }

    @Override
    public void deleteCodeFiles() throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteDirectory(this.directory);
    }

    @Override
    public void initWebAppTemplate(String templateId, File templateDir) throws IOException {
        logger.info((Object)("Init streamlit webapp with template: " + templateId));
        this.params.python = "";
        File backendFile = this.getMainPythonFile(templateDir);
        if (backendFile.exists()) {
            this.params.python = FileUtils.readFileToString((File)backendFile, (Charset)StandardCharsets.UTF_8);
        }
        this.params.config = "";
        File configFile = this.getConfigFile(templateDir);
        if (configFile.exists()) {
            this.params.config = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
        }
    }
}

