/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.client;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResourceIdentifier;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class AzureMLLambdaAPIClient
implements BaseLambdaAPIClient {
    private static final String EXPLANATIONS_PROPERTY = "explanations";
    private static final Logger logger = Logger.getLogger((String)"dku.lambda.test.azureml");

    public static ApiEndpointQuery updateQueryToAzureMLExpectedFormat(ApiEndpointQuery query, LambdaEndpointConfig.EndpointType endpointType) throws IllegalArgumentException {
        switch (endpointType) {
            case STD_PREDICTION: 
            case STD_CAUSAL_PREDICTION: 
            case STD_CLUSTERING: 
            case CUSTOM_PREDICTION: {
                return AzureMLLambdaAPIClient.createAzureMLPredictionQuery(query);
            }
            case PY_FUNCTION: {
                return query;
            }
        }
        throw new IllegalArgumentException("Unsupported endpoint type " + String.valueOf((Object)endpointType));
    }

    private static ApiEndpointQuery createAzureMLPredictionQuery(ApiEndpointQuery tq) {
        ApiEndpointQuery tqCopy = (ApiEndpointQuery)JSON.deepCopy((Object)tq);
        AzureMLPredictionQuery azureMLPredictionQuery = new AzureMLPredictionQuery();
        if (tq.q.has(EXPLANATIONS_PROPERTY)) {
            azureMLPredictionQuery.explanations = tqCopy.q.get(EXPLANATIONS_PROPERTY);
            tqCopy.q.remove(EXPLANATIONS_PROPERTY);
        }
        azureMLPredictionQuery.items.add((JsonElement)tqCopy.q);
        JsonObject updatedQuery = JSON.toJsonObject((Object)azureMLPredictionQuery, (String[])new String[0]);
        return new ApiEndpointQuery(tq.name, updatedQuery);
    }

    public static BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(AuthCtx authCtx, AbstractFullyManagedAPIDeploymentInfra infra, String deploymentId, AzureMLResourceIdentifier azEndpointIdentifier, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, Collection<ApiEndpointQuery> queries, boolean forTest) throws IOException, AzureMLUtils.AzureAuthenticationException, DKUSecurityException {
        BaseLambdaAPIClient.ApiEndpointResponses apiEndpointResponses = new BaseLambdaAPIClient.ApiEndpointResponses();
        try (AzureMLUtils.AzureSession session = AzureMLUtils.loginOrCheckAzure_NT(authCtx, infra.authConnection);){
            File tmpDir = DKUApp.getFile((String[])new String[]{"tmp", "api_deployer", deploymentId});
            File contextDir = new File(tmpDir, "querier_input");
            DKUFileUtils.mkdirs((File)contextDir);
            for (ApiEndpointQuery tq : queries) {
                BaseLambdaAPIClient.ResponseOrError roe = new BaseLambdaAPIClient.ResponseOrError();
                roe.query = tq;
                JsonObject azureMLQuery = tq.q;
                try {
                    String azureMLQueryJSON = JSON.json((Object)azureMLQuery);
                    logger.debug((Object)("Submit query with name `" + tq.name + "` and body `" + azureMLQueryJSON + "` to Azure ML endpoint " + azEndpointIdentifier.name));
                    String response = AzureMLUtils.invokeEndpoint_NT(session, azEndpointIdentifier, azureMLQuery, contextDir);
                    roe.response = JSON.parse((String)response, JsonObject.class);
                }
                catch (Exception e) {
                    logger.warn((Object)("Query " + JSON.log((Object)azureMLQuery) + " sent to Azure ML endpoint " + azEndpointIdentifier.name + " failed."), (Throwable)e);
                    roe.error = new SerializedError((Throwable)e, !ApplicationConfigurator.hideErrorStacks(), !DKUApp.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                }
                apiEndpointResponses.responses.add(roe);
            }
            BaseLambdaAPIClient.ApiEndpointResponses apiEndpointResponses2 = apiEndpointResponses;
            return apiEndpointResponses2;
        }
    }

    private static class AzureMLPredictionQuery {
        List<JsonElement> items = new ArrayList<JsonElement>();
        JsonElement explanations;

        private AzureMLPredictionQuery() {
        }
    }
}

