/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.utils;

import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;

public class PageContentStreamOptimized {
    private static final Matrix ROTATION = Matrix.getRotateInstance((double)1.5707963267948966, (float)0.0f, (float)0.0f);
    private final PDPageContentStream pageContentStream;
    private boolean textMode;
    private float textCursorAbsoluteX;
    private float textCursorAbsoluteY;
    private boolean rotated;
    private PDFont currentFont;
    private float currentFontSize;
    private Color currentStrokingColor;
    private Color currentNonStrokingColor;
    private float currentLineWidth = -1.0f;
    private int currentLineCapStyle = -1;
    private float[] currentLineDashPattern;
    private float currentLineDashPhase;

    public PageContentStreamOptimized(PDPageContentStream pageContentStream) {
        this.pageContentStream = pageContentStream;
    }

    public void setRotated(boolean rotated) throws IOException {
        if (this.rotated == rotated) {
            return;
        }
        if (rotated) {
            if (this.textMode) {
                this.pageContentStream.setTextMatrix(ROTATION);
                this.textCursorAbsoluteX = 0.0f;
                this.textCursorAbsoluteY = 0.0f;
            }
        } else {
            this.endText();
        }
        this.rotated = rotated;
    }

    public void beginText() throws IOException {
        if (!this.textMode) {
            this.pageContentStream.beginText();
            if (this.rotated) {
                this.pageContentStream.setTextMatrix(ROTATION);
            }
            this.textMode = true;
            this.textCursorAbsoluteX = 0.0f;
            this.textCursorAbsoluteY = 0.0f;
        }
    }

    public void endText() throws IOException {
        if (this.textMode) {
            this.pageContentStream.endText();
            this.textMode = false;
        }
    }

    public void setFont(PDFont font, float fontSize) throws IOException {
        if (font != this.currentFont || fontSize != this.currentFontSize) {
            this.pageContentStream.setFont(font, fontSize);
            this.currentFont = font;
            this.currentFontSize = fontSize;
        }
    }

    public void showText(String text) throws IOException {
        this.beginText();
        this.pageContentStream.showText(text);
    }

    public void newLineAt(float tx, float ty) throws IOException {
        this.beginText();
        float dx = tx - this.textCursorAbsoluteX;
        float dy = ty - this.textCursorAbsoluteY;
        if (this.rotated) {
            this.pageContentStream.newLineAtOffset(dy, -dx);
        } else {
            this.pageContentStream.newLineAtOffset(dx, dy);
        }
        this.textCursorAbsoluteX = tx;
        this.textCursorAbsoluteY = ty;
    }

    public void drawImage(PDImageXObject image, float x, float y, float width, float height) throws IOException {
        this.endText();
        this.pageContentStream.drawImage(image, x, y, width, height);
    }

    public void setStrokingColor(Color color) throws IOException {
        if (color != this.currentStrokingColor) {
            this.pageContentStream.setStrokingColor(color);
            this.currentStrokingColor = color;
        }
    }

    public void setNonStrokingColor(Color color) throws IOException {
        if (color != this.currentNonStrokingColor) {
            this.pageContentStream.setNonStrokingColor(color);
            this.currentNonStrokingColor = color;
        }
    }

    public void addRect(float x, float y, float width, float height) throws IOException {
        this.endText();
        this.pageContentStream.addRect(x, y, width, height);
    }

    public void moveTo(float x, float y) throws IOException {
        this.endText();
        this.pageContentStream.moveTo(x, y);
    }

    public void lineTo(float x, float y) throws IOException {
        this.endText();
        this.pageContentStream.lineTo(x, y);
    }

    public void stroke() throws IOException {
        this.endText();
        this.pageContentStream.stroke();
    }

    public void fill() throws IOException {
        this.endText();
        this.pageContentStream.fill();
    }

    public void setLineWidth(float lineWidth) throws IOException {
        if (lineWidth != this.currentLineWidth) {
            this.endText();
            this.pageContentStream.setLineWidth(lineWidth);
            this.currentLineWidth = lineWidth;
        }
    }

    public void setLineCapStyle(int lineCapStyle) throws IOException {
        if (lineCapStyle != this.currentLineCapStyle) {
            this.endText();
            this.pageContentStream.setLineCapStyle(lineCapStyle);
            this.currentLineCapStyle = lineCapStyle;
        }
    }

    public void setLineDashPattern(float[] pattern, float phase) throws IOException {
        if (pattern != this.currentLineDashPattern && !Arrays.equals(pattern, this.currentLineDashPattern) || phase != this.currentLineDashPhase) {
            this.endText();
            this.pageContentStream.setLineDashPattern(pattern, phase);
            this.currentLineDashPattern = pattern;
            this.currentLineDashPhase = phase;
        }
    }

    public void close() throws IOException {
        this.endText();
        this.pageContentStream.close();
    }
}

