/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server;

import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.hproxy.server.utils.ClassLoaderPool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Logger;

public class Context {
    private static Logger logger = Logger.getLogger(Context.class);
    private ClassLoaderPool classLoaderPool;
    private FileSystem fileSystem;
    private boolean hiveAvailable;
    private boolean pigAvailable;
    private String secretKey;

    public ClassLoaderPool getClassLoaderPool() {
        return this.classLoaderPool;
    }

    public FileSystem getHadoopFS() {
        return this.fileSystem;
    }

    public boolean isPigAvailable() {
        return this.pigAvailable;
    }

    public boolean isHiveAvailable() {
        return this.hiveAvailable;
    }

    public synchronized String getSecretKey() {
        File ssFile;
        if (StringUtils.isBlank((String)this.secretKey) && (ssFile = new File(System.getenv("DIP_HOME") + "/run/shared-secret.txt")).isFile()) {
            try {
                this.secretKey = DKUFileUtils.readFileToStringUTF8((File)ssFile);
            }
            catch (IOException e) {
                logger.error((Object)"Cannot read shared secret", (Throwable)e);
            }
        }
        if (StringUtils.isBlank((String)this.secretKey)) {
            logger.error((Object)"Shared secret file not found - HProxy server will refuses every request.");
        }
        return this.secretKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Context create() throws IOException {
        Context ctx = new Context();
        ctx.classLoaderPool = new ClassLoaderPool();
        try {
            ClusterSettings clusterSettings = null;
            String clusterSettingsFile = System.getenv("DKU_CLUSTER_SETTINGS_FILE");
            clusterSettings = (ClusterSettings)JSON.parseFile((String)clusterSettingsFile, ClusterSettings.class);
            logger.info((Object)("Create FS requestedClusterSettings=" + JSON.prettyLog((Object)clusterSettings)));
            HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
            HadoopLoader.initializeSecurity((HadoopSettings)hadoopSettings, (boolean)true, (boolean)false);
            ctx.fileSystem = HadoopLoader.getFS((String)"/", (List)hadoopSettings.extraConf.getAsSimpleKeyValueList());
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to load Hadoop", (Throwable)e);
            throw new RuntimeException("Unable to load Hadoop", e);
        }
        String sbcp = System.getenv("HPROXY_SANDBOX_CLASSPATH");
        if (sbcp == null) throw new RuntimeException("Unable to find the HProxy sandbox jar !");
        String[] jars = DKUtils.parseClassPath((String)sbcp);
        if (jars.length <= 0) throw new RuntimeException("Unable to find the HProxy sandbox jar (no jars)");
        try {
            ctx.classLoaderPool.addJarCollection("sandbox", jars);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to find the HProxy sandbox jar (invalid path)");
        }
        String hiveJars = System.getenv("DKU_HIVE_CP");
        ctx.hiveAvailable = false;
        if (hiveJars != null) {
            String hiveAdditionalJars;
            String[] jars2 = DKUtils.parseClassPath((String)hiveJars);
            if (jars2.length > 0) {
                try {
                    ctx.classLoaderPool.addJarCollection("hive", jars2);
                    ctx.hiveAvailable = true;
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)"Hive classpath seems invalid", (Throwable)e);
                }
            }
            if ((hiveAdditionalJars = System.getenv("DKU_HIVE_ADDITIONAL_JARS")) != null && hiveAdditionalJars.trim().length() > 0) {
                String[] additionalJars = DKUtils.parseClassPath((String)hiveAdditionalJars);
                try {
                    ctx.classLoaderPool.addJarCollection("hive-additional", additionalJars);
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)"Hive additional jars path seems invalid", (Throwable)e);
                }
            } else {
                ctx.classLoaderPool.addJarCollection("hive-additional", new String[0]);
            }
        } else {
            logger.warn((Object)"Unable to load Hive");
        }
        String pigJars = System.getenv("DKU_PIG_CP");
        ctx.pigAvailable = false;
        if (pigJars != null) {
            String[] jars3 = DKUtils.parseClassPath((String)pigJars);
            if (jars3.length <= 0) return ctx;
            try {
                ctx.classLoaderPool.addJarCollection("pig", jars3);
                ctx.pigAvailable = true;
                return ctx;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"Pig classpath is invalid", (Throwable)e);
            }
            return ctx;
        } else {
            logger.warn((Object)"Unable to load Pig");
        }
        return ctx;
    }

    private Context() {
    }
}

