/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.util;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final Pattern KEEP_ALPHANUM_DASHES = Pattern.compile("[^0-9a-zA-Z-]");
    public static final Pattern KEEP_ALPHANUM = Pattern.compile("[^0-9a-zA-Z]");
    private static final Pattern DECODE = Pattern.compile("(?:_[0-9a-fA-F]{2})+");
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public static String escape(String str) {
        return StringUtils.escape(str, KEEP_ALPHANUM);
    }

    public static String escape(String str, Pattern encodedChars) {
        Matcher matcher = encodedChars.matcher(str);
        StringBuffer buf = new StringBuffer(str.length());
        while (matcher.find()) {
            String match = matcher.group();
            matcher.appendReplacement(buf, "");
            for (byte b : match.getBytes(CHARSET)) {
                buf.append('_').append(Integer.toString(b & 0xFF, 16));
            }
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public static String unescape(String str) {
        Matcher matcher = DECODE.matcher(str);
        StringBuffer buf = new StringBuffer(str.length());
        while (matcher.find()) {
            String hex = matcher.group();
            int len = hex.length() / 3;
            byte[] bytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                bytes[i] = Integer.valueOf(hex.substring(3 * i + 1, 3 * i + 3), 16).byteValue();
            }
            matcher.appendReplacement(buf, "");
            buf.append(new String(bytes, CHARSET));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }
}

