/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.DeleteModelVersionRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.GetByAliasRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.GetModelVersionRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ListModelVersionsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ListModelVersionsResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ModelVersionInfo;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ModelVersionsImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ModelVersionsService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.UpdateModelVersionRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ModelVersionsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ModelVersionsAPI.class);
    private final ModelVersionsService impl;

    public ModelVersionsAPI(ApiClient apiClient) {
        this.impl = new ModelVersionsImpl(apiClient);
    }

    public ModelVersionsAPI(ModelVersionsService mock) {
        this.impl = mock;
    }

    public void delete(String fullName, long version) {
        this.delete(new DeleteModelVersionRequest().setFullName(fullName).setVersion(version));
    }

    public void delete(DeleteModelVersionRequest request) {
        this.impl.delete(request);
    }

    public ModelVersionInfo get(String fullName, long version) {
        return this.get(new GetModelVersionRequest().setFullName(fullName).setVersion(version));
    }

    public ModelVersionInfo get(GetModelVersionRequest request) {
        return this.impl.get(request);
    }

    public ModelVersionInfo getByAlias(String fullName, String alias) {
        return this.getByAlias(new GetByAliasRequest().setFullName(fullName).setAlias(alias));
    }

    public ModelVersionInfo getByAlias(GetByAliasRequest request) {
        return this.impl.getByAlias(request);
    }

    public Iterable<ModelVersionInfo> list(String fullName) {
        return this.list(new ListModelVersionsRequest().setFullName(fullName));
    }

    public Iterable<ModelVersionInfo> list(ListModelVersionsRequest request) {
        return new Paginator(request, this.impl::list, ListModelVersionsResponse::getModelVersions, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ModelVersionInfo update(String fullName, long version) {
        return this.update(new UpdateModelVersionRequest().setFullName(fullName).setVersion(version));
    }

    public ModelVersionInfo update(UpdateModelVersionRequest request) {
        return this.impl.update(request);
    }

    public ModelVersionsService impl() {
        return this.impl;
    }
}

