/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.notebook;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.spark.notebook.DkuSparkSQLContext$;
import com.dataiku.dip.spark.notebook.SparkSQLStatementInProgress;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLExecutionResponse;
import com.dataiku.dip.utils.JSON;
import java.io.Serializable;
import java.util.Collection;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0003\u0006\u0001+!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0011!y\u0003A!A!\u0002\u0013\u0001\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011\u0001\u0003!\u0011!Q\u0001\n]B\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\u0019\u0002!\t!\u0014\u0002\u0015\t.,(+Z7pi\u0016$\u0015\r^1tKR\u0014V-\u00193\u000b\u0005-a\u0011\u0001\u00038pi\u0016\u0014wn\\6\u000b\u00055q\u0011!B:qCJ\\'BA\b\u0011\u0003\r!\u0017\u000e\u001d\u0006\u0003#I\tq\u0001Z1uC&\\WOC\u0001\u0014\u0003\r\u0019w.\\\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\u0003g\u0012\u0004\"AH\u0011\u000e\u0003}Q!\u0001\t\b\u0002\u0013\r|'/Z7pI\u0016d\u0017B\u0001\u0012 \u0005E\u0019VM]5bY&TX\r\u001a#bi\u0006\u001cX\r^\u0001\u000bI\u0006$\u0018m]3u\u000b:4\bCA\u0013-\u001d\t1#\u0006\u0005\u0002(15\t\u0001F\u0003\u0002*)\u00051AH]8pizJ!a\u000b\r\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003Wa\t\u0001b]1na2Lgn\u001a\t\u0003cQj\u0011A\r\u0006\u0003g9\t\u0001\u0002Z1uCN,Go]\u0005\u0003kI\u0012QbU1na2Lgn\u001a)be\u0006l\u0017A\u00039beRLG/[8ogB\u0019\u0001(\u0010\u0013\u000f\u0005eZdBA\u0014;\u0013\u0005I\u0012B\u0001\u001f\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!AP \u0003\t1K7\u000f\u001e\u0006\u0003ya\t1bY8mk6tg*Y7fg\u0006\u0001b-\u001b7uKJ,\u0005\u0010\u001d:fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u00113u\tS%K\u0017B\u0011Q\tA\u0007\u0002\u0015!)Ad\u0002a\u0001;!)1e\u0002a\u0001I!)qf\u0002a\u0001a!)ag\u0002a\u0001o!)\u0001i\u0002a\u0001o!)\u0011i\u0002a\u0001I\u0005iAm\u001c*fC\u0012$\u0015\r^1tKR$\"A\u0014+\u0011\u0005=\u0013V\"\u0001)\u000b\u0005Ec\u0011\u0001C:qCJ\\7/\u001d7\n\u0005M\u0003&\u0001\b#lkN\u0003\u0018M]6T#2+\u00050Z2vi&|gNU3ta>t7/\u001a\u0005\u0006+\"\u0001\rAV\u0001\u0003g\u000e\u0004\"aV/\u000e\u0003aS!!D-\u000b\u0005i[\u0016AB1qC\u000eDWMC\u0001]\u0003\ry'oZ\u0005\u0003=b\u0013Ab\u00159be.\u001cuN\u001c;fqR\u0004")
public class DkuRemoteDatasetRead {
    private final SerializedDataset sd;
    private final String datasetEnv;
    private final SamplingParam sampling;
    private final List<String> partitions;
    private final List<String> columnNames;
    private final String filterExpression;

    public DkuSparkSQLExecutionResponse doReadDataset(SparkContext sc) {
        Object object;
        DkuSparkSQLExecutionResponse ret = new DkuSparkSQLExecutionResponse();
        try {
            DkuSparkSQLContext$.MODULE$.logger().info((Object)new StringBuilder(13).append("Read dataset ").append(this.sd.getFullName()).toString());
            DkuSparkSQLContext$.MODULE$.init(sc, true, (Option<String>)Option$.MODULE$.apply((Object)"default"));
            ((SparkJobExecEnv)JSON.parse((String)this.datasetEnv, SparkJobExecEnv.class)).loadInDriver();
            Dataset dataset = Dataset.fromSerialized((SerializedDataset)this.sd);
            Tuple2<org.apache.spark.sql.Dataset<Row>, FlowDatasetRef.InputDatasetDataframeReadMode> dfWithMode = DkuSparkSQLContext$.MODULE$.dsc().getAsSampledDataFrameInternal(DkuSparkSQLContext$.MODULE$.ssc(), dataset, this.sampling, this.partitions, this.columnNames, this.filterExpression);
            org.apache.spark.sql.Dataset df = (org.apache.spark.sql.Dataset)dfWithMode._1();
            StructType dfSchema = df.schema();
            String statementIdentifier = new StringBuilder(12).append("datasetRead:").append(dataset.getFullName()).toString();
            DkuSparkSQLContext$.MODULE$.sharedIterators().put(statementIdentifier, new SparkSQLStatementInProgress((org.apache.spark.sql.Dataset<Row>)df, dfSchema, null));
            ret.iteratorIsReady = false;
            ret.statementIdentifier = statementIdentifier;
            object = BoxesRunTime.boxToBoolean((boolean)ret.schema.columns.addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dfSchema.map((Function1 & Serializable & scala.Serializable)f -> package$.MODULE$.sparkToDku((StructField)f), Seq$.MODULE$.canBuildFrom())).asJava()));
        }
        catch (Throwable t) {
            DkuSparkSQLContext$.MODULE$.logger().error((Object)"Failed to prepare read", t);
            ret.error = new SerializedError(t, true);
            object = BoxedUnit.UNIT;
        }
        return ret;
    }

    public DkuRemoteDatasetRead(SerializedDataset sd, String datasetEnv, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
        this.sd = sd;
        this.datasetEnv = datasetEnv;
        this.sampling = sampling;
        this.partitions = partitions;
        this.columnNames = columnNames;
        this.filterExpression = filterExpression;
    }
}

