/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.cert.crmf;

import com.databricks.internal.bouncycastle.asn1.cms.EnvelopedData;
import com.databricks.internal.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import com.databricks.internal.bouncycastle.asn1.crmf.EncKeyWithID;
import com.databricks.internal.bouncycastle.asn1.crmf.EncryptedKey;
import com.databricks.internal.bouncycastle.asn1.crmf.PKIArchiveOptions;
import com.databricks.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.databricks.internal.bouncycastle.asn1.x509.GeneralName;
import com.databricks.internal.bouncycastle.cert.crmf.PKIArchiveControl;
import com.databricks.internal.bouncycastle.cms.CMSEnvelopedData;
import com.databricks.internal.bouncycastle.cms.CMSEnvelopedDataGenerator;
import com.databricks.internal.bouncycastle.cms.CMSException;
import com.databricks.internal.bouncycastle.cms.CMSProcessableByteArray;
import com.databricks.internal.bouncycastle.cms.RecipientInfoGenerator;
import com.databricks.internal.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.envGen.addRecipientInfoGenerator(recipientInfoGenerator);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor outputEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.envGen.generate(this.keyContent, outputEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

