/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.jcajce.provider.asymmetric.slhdsa;

import com.databricks.internal.bouncycastle.asn1.ASN1Set;
import com.databricks.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.databricks.internal.bouncycastle.jcajce.interfaces.SLHDSAPrivateKey;
import com.databricks.internal.bouncycastle.jcajce.interfaces.SLHDSAPublicKey;
import com.databricks.internal.bouncycastle.jcajce.provider.asymmetric.slhdsa.BCSLHDSAPublicKey;
import com.databricks.internal.bouncycastle.jcajce.spec.SLHDSAParameterSpec;
import com.databricks.internal.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.slhdsa.SLHDSAPublicKeyParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.databricks.internal.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.databricks.internal.bouncycastle.util.Arrays;
import com.databricks.internal.bouncycastle.util.Fingerprint;
import com.databricks.internal.bouncycastle.util.Strings;
import com.databricks.internal.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BCSLHDSAPrivateKey
implements SLHDSAPrivateKey {
    private static final long serialVersionUID = 1L;
    private transient SLHDSAPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSLHDSAPrivateKey(SLHDSAPrivateKeyParameters sLHDSAPrivateKeyParameters) {
        this.params = sLHDSAPrivateKeyParameters;
    }

    public BCSLHDSAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (SLHDSAPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSLHDSAPrivateKey) {
            BCSLHDSAPrivateKey bCSLHDSAPrivateKey = (BCSLHDSAPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSLHDSAPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "SLH-DSA-" + Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public SLHDSAPublicKey getPublicKey() {
        return new BCSLHDSAPublicKey(new SLHDSAPublicKeyParameters(this.params.getParameters(), this.params.getPublicKey()));
    }

    @Override
    public SLHDSAParameterSpec getParameterSpec() {
        return SLHDSAParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        byte[] byArray = this.params.getPublicKey();
        stringBuilder.append(this.getAlgorithm()).append(" ").append("Private Key").append(" [").append(new Fingerprint(byArray).toString()).append("]").append(string).append("    public data: ").append(Hex.toHexString(byArray)).append(string);
        return stringBuilder.toString();
    }

    SLHDSAPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

