/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.utils;

import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.utils.Environment;
import com.databricks.internal.sdk.core.utils.LinuxUtilities;
import com.databricks.internal.sdk.core.utils.MacOSUtilities;
import com.databricks.internal.sdk.core.utils.OSUtilities;
import com.databricks.internal.sdk.core.utils.WindowsUtilities;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class OSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OSUtils.class);

    static String getOS(Environment env) {
        String systemName = env.getSystemName().toLowerCase();
        if (systemName.startsWith("win")) {
            return "win";
        }
        if (systemName.startsWith("mac")) {
            return "mac";
        }
        return "linux";
    }

    public static OSUtilities get(Environment env) {
        String os;
        switch (os = OSUtils.getOS(env)) {
            case "win": {
                return new WindowsUtilities(env);
            }
            case "mac": {
                return new MacOSUtilities(env);
            }
            case "linux": {
                return new LinuxUtilities(env);
            }
        }
        throw new DatabricksException("Unsupported OS: " + os);
    }

    public static String findExecutable(List<String> paths, String name) {
        LOG.debug("Searching for executable named '" + name + "' in : " + String.join((CharSequence)", ", paths));
        for (String dir : paths) {
            long size;
            Path path = Paths.get(dir, name).toAbsolutePath().normalize();
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            try {
                size = Files.size(path);
            }
            catch (IOException e) {
                LOG.debug("Unable to get size of databricks cli, continuing", e);
                continue;
            }
            if (size < 0x100000L) {
                LOG.debug("Databricks CLI version <0.100.0 detected");
                continue;
            }
            String pathStr = path.toString();
            LOG.debug("Found executable named '" + name + "' in PATH: " + pathStr);
            return pathStr;
        }
        LOG.debug("Failed to find executable named '" + name + "' in PATH");
        return null;
    }
}

