/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.iam.AccountUsersImpl;
import com.databricks.internal.sdk.service.iam.AccountUsersService;
import com.databricks.internal.sdk.service.iam.DeleteAccountUserRequest;
import com.databricks.internal.sdk.service.iam.GetAccountUserRequest;
import com.databricks.internal.sdk.service.iam.ListAccountUsersRequest;
import com.databricks.internal.sdk.service.iam.ListUsersResponse;
import com.databricks.internal.sdk.service.iam.PartialUpdate;
import com.databricks.internal.sdk.service.iam.User;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class AccountUsersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountUsersAPI.class);
    private final AccountUsersService impl;

    public AccountUsersAPI(ApiClient apiClient) {
        this.impl = new AccountUsersImpl(apiClient);
    }

    public AccountUsersAPI(AccountUsersService mock) {
        this.impl = mock;
    }

    public User create(User request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteAccountUserRequest().setId(id));
    }

    public void delete(DeleteAccountUserRequest request) {
        this.impl.delete(request);
    }

    public User get(String id) {
        return this.get(new GetAccountUserRequest().setId(id));
    }

    public User get(GetAccountUserRequest request) {
        return this.impl.get(request);
    }

    public Iterable<User> list(ListAccountUsersRequest request) {
        request.setStartIndex(1L);
        if (request.getCount() == null) {
            request.setCount(10000L);
        }
        return new Paginator<ListAccountUsersRequest, ListUsersResponse, User>(request, this.impl::list, ListUsersResponse::getResources, response -> {
            Long offset = request.getStartIndex();
            if (offset == null) {
                offset = 0L;
            }
            offset = offset + (long)response.getResources().size();
            return request.setStartIndex(offset);
        }).withDedupe(User::getId);
    }

    public void patch(PartialUpdate request) {
        this.impl.patch(request);
    }

    public void update(User request) {
        this.impl.update(request);
    }

    public AccountUsersService impl() {
        return this.impl;
    }
}

