/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.settingsv2;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.settingsv2.GetPublicWorkspaceSettingRequest;
import com.databricks.internal.sdk.service.settingsv2.ListWorkspaceSettingsMetadataRequest;
import com.databricks.internal.sdk.service.settingsv2.ListWorkspaceSettingsMetadataResponse;
import com.databricks.internal.sdk.service.settingsv2.PatchPublicWorkspaceSettingRequest;
import com.databricks.internal.sdk.service.settingsv2.Setting;
import com.databricks.internal.sdk.service.settingsv2.SettingsMetadata;
import com.databricks.internal.sdk.service.settingsv2.WorkspaceSettingsV2Impl;
import com.databricks.internal.sdk.service.settingsv2.WorkspaceSettingsV2Service;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class WorkspaceSettingsV2API {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceSettingsV2API.class);
    private final WorkspaceSettingsV2Service impl;

    public WorkspaceSettingsV2API(ApiClient apiClient) {
        this.impl = new WorkspaceSettingsV2Impl(apiClient);
    }

    public WorkspaceSettingsV2API(WorkspaceSettingsV2Service mock) {
        this.impl = mock;
    }

    public Setting getPublicWorkspaceSetting(String name) {
        return this.getPublicWorkspaceSetting(new GetPublicWorkspaceSettingRequest().setName(name));
    }

    public Setting getPublicWorkspaceSetting(GetPublicWorkspaceSettingRequest request) {
        return this.impl.getPublicWorkspaceSetting(request);
    }

    public Iterable<SettingsMetadata> listWorkspaceSettingsMetadata(ListWorkspaceSettingsMetadataRequest request) {
        return new Paginator(request, this.impl::listWorkspaceSettingsMetadata, ListWorkspaceSettingsMetadataResponse::getSettingsMetadata, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Setting patchPublicWorkspaceSetting(PatchPublicWorkspaceSettingRequest request) {
        return this.impl.patchPublicWorkspaceSetting(request);
    }

    public WorkspaceSettingsV2Service impl() {
        return this.impl;
    }
}

