/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.api.impl.ColumnarRowView;
import com.databricks.jdbc.api.impl.IExecutionResult;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.util.DatabricksThriftUtil;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;

public class LazyThriftResult
implements IExecutionResult {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(LazyThriftResult.class);
    private TFetchResultsResp currentResponse;
    private ColumnarRowView currentBatch;
    private int currentBatchIndex;
    private long globalRowIndex;
    private final IDatabricksSession session;
    private final IDatabricksStatementInternal statement;
    private final int maxRows;
    private boolean hasReachedEnd;
    private boolean isClosed;
    private long totalRowsFetched;

    public LazyThriftResult(TFetchResultsResp initialResponse, IDatabricksStatementInternal statement, IDatabricksSession session) throws DatabricksSQLException {
        this.currentResponse = initialResponse;
        this.statement = statement;
        this.session = session;
        this.maxRows = statement != null ? statement.getMaxRows() : 0;
        this.globalRowIndex = -1L;
        this.currentBatchIndex = -1;
        this.hasReachedEnd = false;
        this.isClosed = false;
        this.totalRowsFetched = 0L;
        this.loadCurrentBatch();
        LOGGER.debug("LazyThriftResult initialized with {} rows in first batch, hasMoreRows: {}", this.currentBatch.getRowCount(), this.currentResponse.hasMoreRows);
    }

    @Override
    public Object getObject(int columnIndex) throws DatabricksSQLException {
        if (this.isClosed) {
            throw new DatabricksSQLException("Result is already closed", DatabricksDriverErrorCode.STATEMENT_CLOSED);
        }
        if (this.globalRowIndex == -1L) {
            throw new DatabricksSQLException("Cursor is before first row", DatabricksDriverErrorCode.INVALID_STATE);
        }
        if (this.currentBatchIndex < 0 || this.currentBatchIndex >= this.currentBatch.getRowCount()) {
            throw new DatabricksSQLException("Invalid cursor position", DatabricksDriverErrorCode.INVALID_STATE);
        }
        if (columnIndex < 0 || columnIndex >= this.currentBatch.getColumnCount()) {
            throw new DatabricksSQLException("Column index out of bounds " + columnIndex, DatabricksDriverErrorCode.INVALID_STATE);
        }
        return this.currentBatch.getValue(this.currentBatchIndex, columnIndex);
    }

    @Override
    public long getCurrentRow() {
        return this.globalRowIndex;
    }

    @Override
    public boolean next() throws DatabricksSQLException {
        boolean hasRowLimit;
        if (this.isClosed || this.hasReachedEnd) {
            return false;
        }
        if (!this.hasNext()) {
            return false;
        }
        boolean bl = hasRowLimit = this.maxRows > 0;
        if (hasRowLimit && this.globalRowIndex + 1L >= (long)this.maxRows) {
            this.hasReachedEnd = true;
            return false;
        }
        ++this.currentBatchIndex;
        ++this.globalRowIndex;
        if (this.currentBatchIndex >= this.currentBatch.getRowCount()) {
            while (this.currentResponse.hasMoreRows) {
                this.fetchNextBatch();
                if (this.currentBatch.getRowCount() <= 0) continue;
                this.currentBatchIndex = 0;
                break;
            }
            if (this.currentBatch.getRowCount() == 0) {
                this.hasReachedEnd = true;
                --this.globalRowIndex;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        boolean hasRowLimit;
        if (this.isClosed || this.hasReachedEnd) {
            return false;
        }
        boolean bl = hasRowLimit = this.maxRows > 0;
        if (hasRowLimit && this.globalRowIndex + 1L >= (long)this.maxRows) {
            return false;
        }
        if (this.currentBatchIndex + 1 < this.currentBatch.getRowCount()) {
            return true;
        }
        return this.currentResponse.hasMoreRows;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.currentBatch = null;
        this.currentResponse = null;
        LOGGER.debug("LazyThriftResult closed after fetching {} total rows", this.totalRowsFetched);
    }

    @Override
    public long getRowCount() {
        return this.currentBatch != null ? (long)this.currentBatch.getRowCount() : 0L;
    }

    @Override
    public long getChunkCount() {
        return 0L;
    }

    private void loadCurrentBatch() throws DatabricksSQLException {
        this.currentBatch = DatabricksThriftUtil.createColumnarView(this.currentResponse.getResults());
        this.currentBatchIndex = -1;
        this.totalRowsFetched += (long)this.currentBatch.getRowCount();
        LOGGER.debug("Loaded batch with {} rows, total fetched: {}", this.currentBatch.getRowCount(), this.totalRowsFetched);
    }

    private void fetchNextBatch() throws DatabricksSQLException {
        try {
            LOGGER.debug("Fetching next batch, current total rows fetched: {}", this.totalRowsFetched);
            this.currentResponse = this.session.getDatabricksClient().getMoreResults(this.statement);
            this.loadCurrentBatch();
            LOGGER.debug("Fetched batch with {} rows, hasMoreRows: {}", this.currentBatch.getRowCount(), this.currentResponse.hasMoreRows);
        }
        catch (DatabricksSQLException e) {
            LOGGER.error("Failed to fetch next batch: {}", e.getMessage());
            this.hasReachedEnd = true;
            throw e;
        }
    }

    public long getTotalRowsFetched() {
        return this.totalRowsFetched;
    }

    public boolean isCompletelyFetched() {
        return this.hasReachedEnd || !this.currentResponse.hasMoreRows;
    }
}

