/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.jdbc.api.impl.arrow.ChunkLinkFetcher;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.core.ChunkLinkFetchResult;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;

public class ThriftChunkLinkFetcher
implements ChunkLinkFetcher {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(ThriftChunkLinkFetcher.class);
    private final IDatabricksSession session;
    private final StatementId statementId;

    public ThriftChunkLinkFetcher(IDatabricksSession session, StatementId statementId) {
        this.session = session;
        this.statementId = statementId;
        LOGGER.debug("Created ThriftChunkLinkFetcher for statement {}", statementId);
    }

    @Override
    public ChunkLinkFetchResult fetchLinks(long startChunkIndex, long startRowOffset) throws DatabricksSQLException {
        LOGGER.debug("Fetching links starting from chunk index {}, row offset {} for statement {}", startChunkIndex, startRowOffset, this.statementId);
        return this.session.getDatabricksClient().getResultChunks(this.statementId, startChunkIndex, startRowOffset);
    }

    @Override
    public ExternalLink refetchLink(long chunkIndex, long rowOffset) throws DatabricksSQLException {
        LOGGER.info("Refetching expired link for chunk {}, row offset {} of statement {}", chunkIndex, rowOffset, this.statementId);
        int maxRetries = 100;
        int retryCount = 0;
        while (retryCount < maxRetries) {
            ChunkLinkFetchResult result = this.session.getDatabricksClient().getResultChunks(this.statementId, chunkIndex, rowOffset);
            if (!result.getChunkLinks().isEmpty()) {
                for (ExternalLink link : result.getChunkLinks()) {
                    if (link.getChunkIndex() != chunkIndex) continue;
                    LOGGER.debug("Successfully refetched link for chunk {} of statement {}", chunkIndex, this.statementId);
                    return link;
                }
                throw new DatabricksSQLException(String.format("Failed to refetch link for chunk %d: server returned links but none matched requested index", chunkIndex), DatabricksDriverErrorCode.CHUNK_READY_ERROR);
            }
            if (!result.hasMore()) {
                throw new DatabricksSQLException(String.format("Failed to refetch link for chunk %d: no links returned and hasMore=false", chunkIndex), DatabricksDriverErrorCode.CHUNK_READY_ERROR);
            }
            LOGGER.debug("No links returned for chunk {} but hasMore=true, retrying ({}/{})", chunkIndex, ++retryCount, maxRetries);
        }
        throw new DatabricksSQLException(String.format("Failed to refetch link for chunk %d: max retries (%d) exceeded", chunkIndex, maxRetries), DatabricksDriverErrorCode.CHUNK_READY_ERROR);
    }

    @Override
    public void close() {
        LOGGER.debug("Closing ThriftChunkLinkFetcher for statement {}", this.statementId);
    }
}

