/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.jdbc.api.impl.converters.ObjectConverter;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class FloatConverter
implements ObjectConverter {
    @Override
    public float toFloat(Object object) throws DatabricksSQLException {
        if (object instanceof String) {
            return Float.parseFloat((String)object);
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        throw new DatabricksSQLException("Unsupported type for FloatObjectConverter: " + String.valueOf(object.getClass()), DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    @Override
    public byte toByte(Object object) throws DatabricksSQLException {
        float value = this.toFloat(object);
        if (value >= -128.0f && value <= 127.0f) {
            return (byte)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Float value out of byte range");
    }

    @Override
    public short toShort(Object object) throws DatabricksSQLException {
        float value = this.toFloat(object);
        if (value >= -32768.0f && value <= 32767.0f) {
            return (short)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Float value out of short range");
    }

    @Override
    public int toInt(Object object) throws DatabricksSQLException {
        float value = this.toFloat(object);
        if (value >= -2.1474836E9f && value < 2.1474836E9f) {
            return (int)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Float value out of int range");
    }

    @Override
    public long toLong(Object object) throws DatabricksSQLException {
        float value = this.toFloat(object);
        if (value >= -9.223372E18f && value < 9.223372E18f) {
            return (long)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Float value out of long range");
    }

    @Override
    public double toDouble(Object object) throws DatabricksSQLException {
        return this.toFloat(object);
    }

    @Override
    public BigDecimal toBigDecimal(Object object) throws DatabricksSQLException {
        return new BigDecimal(Float.toString(this.toFloat(object)));
    }

    @Override
    public BigInteger toBigInteger(Object object) throws DatabricksSQLException {
        return BigInteger.valueOf(this.toLong(object));
    }

    @Override
    public boolean toBoolean(Object object) throws DatabricksSQLException {
        return this.toFloat(object) != 0.0f;
    }

    @Override
    public byte[] toByteArray(Object object) throws DatabricksSQLException {
        return ByteBuffer.allocate(4).putFloat(this.toFloat(object)).array();
    }

    @Override
    public String toString(Object object) throws DatabricksSQLException {
        return String.valueOf(this.toFloat(object));
    }
}

