/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a;

import com.dataiku.dss.shadeliba2a.io.a2a.client.http.A2ACardResolver;
import com.dataiku.dss.shadeliba2a.io.a2a.client.http.A2AHttpClient;
import com.dataiku.dss.shadeliba2a.io.a2a.client.http.JdkA2AHttpClient;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.A2AClientError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.A2AClientJSONError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentCard;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Message;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Part;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TextPart;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class A2A {
    public static Message toUserMessage(String text) {
        return A2A.toMessage(text, Message.Role.USER, null);
    }

    public static Message toUserMessage(String text, String messageId) {
        return A2A.toMessage(text, Message.Role.USER, messageId);
    }

    public static Message toAgentMessage(String text) {
        return A2A.toMessage(text, Message.Role.AGENT, null);
    }

    public static Message toAgentMessage(String text, String messageId) {
        return A2A.toMessage(text, Message.Role.AGENT, messageId);
    }

    public static Message createUserTextMessage(String text, String contextId, String taskId) {
        return A2A.toMessage(text, Message.Role.USER, null, contextId, taskId);
    }

    public static Message createAgentTextMessage(String text, String contextId, String taskId) {
        return A2A.toMessage(text, Message.Role.AGENT, null, contextId, taskId);
    }

    public static Message createAgentPartsMessage(List<Part<?>> parts, String contextId, String taskId) {
        if (parts == null || parts.isEmpty()) {
            throw new IllegalArgumentException("Parts cannot be null or empty");
        }
        return A2A.toMessage(parts, Message.Role.AGENT, null, contextId, taskId);
    }

    private static Message toMessage(String text, Message.Role role, String messageId) {
        return A2A.toMessage(text, role, messageId, null, null);
    }

    private static Message toMessage(String text, Message.Role role, String messageId, String contextId, String taskId) {
        Message.Builder messageBuilder = new Message.Builder().role(role).parts(Collections.singletonList(new TextPart(text))).contextId(contextId).taskId(taskId);
        if (messageId != null) {
            messageBuilder.messageId(messageId);
        }
        return messageBuilder.build();
    }

    private static Message toMessage(List<Part<?>> parts, Message.Role role, String messageId, String contextId, String taskId) {
        Message.Builder messageBuilder = new Message.Builder().role(role).parts(parts).contextId(contextId).taskId(taskId);
        if (messageId != null) {
            messageBuilder.messageId(messageId);
        }
        return messageBuilder.build();
    }

    public static AgentCard getAgentCard(String agentUrl) throws A2AClientError, A2AClientJSONError {
        return A2A.getAgentCard(new JdkA2AHttpClient(), agentUrl);
    }

    public static AgentCard getAgentCard(A2AHttpClient httpClient, String agentUrl) throws A2AClientError, A2AClientJSONError {
        return A2A.getAgentCard(httpClient, agentUrl, null, null);
    }

    public static AgentCard getAgentCard(String agentUrl, String relativeCardPath, Map<String, String> authHeaders) throws A2AClientError, A2AClientJSONError {
        return A2A.getAgentCard(new JdkA2AHttpClient(), agentUrl, relativeCardPath, authHeaders);
    }

    public static AgentCard getAgentCard(A2AHttpClient httpClient, String agentUrl, String relativeCardPath, Map<String, String> authHeaders) throws A2AClientError, A2AClientJSONError {
        A2ACardResolver resolver = new A2ACardResolver(httpClient, agentUrl, relativeCardPath, authHeaders);
        return resolver.getAgentCard();
    }
}

