/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.spec;

import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.annotation.JsonInclude;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentCapabilities;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentCardSignature;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentInterface;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentProvider;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentSkill;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.SecurityScheme;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TransportProtocol;
import com.dataiku.dss.shadeliba2a.io.a2a.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public record AgentCard(String name, String description, String url, AgentProvider provider, String version, String documentationUrl, AgentCapabilities capabilities, List<String> defaultInputModes, List<String> defaultOutputModes, List<AgentSkill> skills, boolean supportsAuthenticatedExtendedCard, Map<String, SecurityScheme> securitySchemes, List<Map<String, List<String>>> security, String iconUrl, List<AgentInterface> additionalInterfaces, String preferredTransport, String protocolVersion, List<AgentCardSignature> signatures) {
    private static final String DEFAULT_PROTOCOL_VERSION = "0.3.0";
    private static final TransportProtocol DEFAULT_TRANSPORT = TransportProtocol.JSONRPC;

    public AgentCard {
        Assert.checkNotNullParam("capabilities", capabilities);
        Assert.checkNotNullParam("defaultInputModes", defaultInputModes);
        Assert.checkNotNullParam("defaultOutputModes", defaultOutputModes);
        Assert.checkNotNullParam("description", description);
        Assert.checkNotNullParam("name", name);
        Assert.checkNotNullParam("skills", skills);
        Assert.checkNotNullParam("url", url);
        Assert.checkNotNullParam("version", version);
        if (protocolVersion == null) {
            protocolVersion = DEFAULT_PROTOCOL_VERSION;
        }
        if (preferredTransport == null) {
            preferredTransport = DEFAULT_TRANSPORT.asString();
        }
    }

    public static class Builder {
        private String name;
        private String description;
        private String url;
        private AgentProvider provider;
        private String version;
        private String documentationUrl;
        private AgentCapabilities capabilities;
        private List<String> defaultInputModes;
        private List<String> defaultOutputModes;
        private List<AgentSkill> skills;
        private boolean supportsAuthenticatedExtendedCard = false;
        private Map<String, SecurityScheme> securitySchemes;
        private List<Map<String, List<String>>> security;
        private String iconUrl;
        private List<AgentInterface> additionalInterfaces;
        private String preferredTransport;
        private String protocolVersion;
        private List<AgentCardSignature> signatures;

        public Builder() {
        }

        public Builder(AgentCard card) {
            this.name = card.name;
            this.description = card.description;
            this.url = card.url;
            this.provider = card.provider;
            this.version = card.version;
            this.documentationUrl = card.documentationUrl;
            this.capabilities = card.capabilities;
            this.defaultInputModes = card.defaultInputModes != null ? new ArrayList<String>(card.defaultInputModes) : null;
            this.defaultOutputModes = card.defaultOutputModes != null ? new ArrayList<String>(card.defaultOutputModes) : null;
            this.skills = card.skills != null ? new ArrayList<AgentSkill>(card.skills) : null;
            this.supportsAuthenticatedExtendedCard = card.supportsAuthenticatedExtendedCard;
            this.securitySchemes = card.securitySchemes != null ? Map.copyOf(card.securitySchemes) : null;
            this.security = card.security != null ? new ArrayList<Map<String, List<String>>>(card.security) : null;
            this.iconUrl = card.iconUrl;
            this.additionalInterfaces = card.additionalInterfaces != null ? new ArrayList<AgentInterface>(card.additionalInterfaces) : null;
            this.preferredTransport = card.preferredTransport;
            this.protocolVersion = card.protocolVersion;
            this.signatures = card.signatures != null ? new ArrayList<AgentCardSignature>(card.signatures) : null;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder provider(AgentProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public Builder capabilities(AgentCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder defaultInputModes(List<String> defaultInputModes) {
            this.defaultInputModes = defaultInputModes;
            return this;
        }

        public Builder defaultOutputModes(List<String> defaultOutputModes) {
            this.defaultOutputModes = defaultOutputModes;
            return this;
        }

        public Builder skills(List<AgentSkill> skills) {
            this.skills = skills;
            return this;
        }

        public Builder supportsAuthenticatedExtendedCard(boolean supportsAuthenticatedExtendedCard) {
            this.supportsAuthenticatedExtendedCard = supportsAuthenticatedExtendedCard;
            return this;
        }

        public Builder securitySchemes(Map<String, SecurityScheme> securitySchemes) {
            this.securitySchemes = securitySchemes;
            return this;
        }

        public Builder security(List<Map<String, List<String>>> security) {
            this.security = security;
            return this;
        }

        public Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public Builder additionalInterfaces(List<AgentInterface> additionalInterfaces) {
            this.additionalInterfaces = additionalInterfaces;
            return this;
        }

        public Builder preferredTransport(String preferredTransport) {
            this.preferredTransport = preferredTransport;
            return this;
        }

        public Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder signatures(List<AgentCardSignature> signatures) {
            this.signatures = signatures;
            return this;
        }

        public AgentCard build() {
            if (this.preferredTransport == null) {
                this.preferredTransport = DEFAULT_TRANSPORT.asString();
            }
            if (this.additionalInterfaces == null) {
                this.additionalInterfaces = new ArrayList<AgentInterface>();
                this.additionalInterfaces.add(new AgentInterface(this.preferredTransport, this.url));
            }
            return new AgentCard(this.name, this.description, this.url, this.provider, this.version, this.documentationUrl, this.capabilities, this.defaultInputModes, this.defaultOutputModes, this.skills, this.supportsAuthenticatedExtendedCard, this.securitySchemes, this.security, this.iconUrl, this.additionalInterfaces, this.preferredTransport, this.protocolVersion, this.signatures);
        }
    }
}

