/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.util;

import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.JsonProcessingException;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.type.TypeReference;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Artifact;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Task;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskArtifactUpdateEvent;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Utils {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = Logger.getLogger(Utils.class.getName());

    public static <T> T unmarshalFrom(String data, TypeReference<T> typeRef) throws JsonProcessingException {
        return OBJECT_MAPPER.readValue(data, typeRef);
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static <T extends Throwable> void rethrow(Throwable t) throws T {
        throw t;
    }

    public static Task appendArtifactToTask(Task task, TaskArtifactUpdateEvent event, String taskId) {
        ArrayList<Artifact> artifacts = task.getArtifacts() == null ? new ArrayList<Artifact>() : new ArrayList<Artifact>(task.getArtifacts());
        Artifact newArtifact = event.getArtifact();
        String artifactId = newArtifact.artifactId();
        boolean appendParts = event.isAppend() != null && event.isAppend() != false;
        Artifact existingArtifact = null;
        int existingArtifactIndex = -1;
        for (int i = 0; i < artifacts.size(); ++i) {
            Artifact curr = (Artifact)artifacts.get(i);
            if (curr.artifactId() == null || !curr.artifactId().equals(artifactId)) continue;
            existingArtifact = curr;
            existingArtifactIndex = i;
            break;
        }
        if (!appendParts) {
            if (existingArtifactIndex >= 0) {
                log.fine(String.format("Replacing artifact at id %s for task %s", artifactId, taskId));
                artifacts.set(existingArtifactIndex, newArtifact);
            } else {
                log.fine(String.format("Adding artifact at id %s for task %s", artifactId, taskId));
                artifacts.add(newArtifact);
            }
        } else if (existingArtifact != null) {
            log.fine(String.format("Appending parts to artifact id %s for task %s", artifactId, taskId));
            ArrayList parts = new ArrayList(existingArtifact.parts());
            parts.addAll(newArtifact.parts());
            Artifact updated = new Artifact.Builder(existingArtifact).parts(parts).build();
            artifacts.set(existingArtifactIndex, updated);
        } else {
            log.warning(String.format("Received append=true for nonexistent artifact index for artifact %s in task %s. Ignoring chunk.", artifactId, taskId));
        }
        return new Task.Builder(task).artifacts(artifacts).build();
    }

    public static String toJsonString(Object o) {
        try {
            return OBJECT_MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        OBJECT_MAPPER.registerModule(new JavaTimeModule());
    }
}

