/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.mutiny.zero.internal;

import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.AlreadyCompletedSubscription;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.IteratorSubscription;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Supplier;

public class GeneratorPublisher<S, T>
implements Flow.Publisher<T> {
    private final Supplier<S> stateSupplier;
    private final Function<S, Iterator<T>> generator;

    public GeneratorPublisher(Supplier<S> stateSupplier, Function<S, Iterator<T>> generator) {
        this.stateSupplier = stateSupplier;
        this.generator = generator;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        Iterator<T> iterator = this.generator.apply(this.stateSupplier.get());
        if (iterator == null) {
            subscriber.onSubscribe(new AlreadyCompletedSubscription());
            subscriber.onError(new IllegalArgumentException("The generator cannot produce a null iterator"));
        } else if (!iterator.hasNext()) {
            subscriber.onSubscribe(new AlreadyCompletedSubscription());
            subscriber.onComplete();
        } else {
            subscriber.onSubscribe(new IteratorSubscription<T>(iterator, subscriber));
        }
    }
}

