/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.snowflake;

import java.util.Locale;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.snowflake.SnowflakeIdentifier;

class NamespaceHelpers {
    private static final int MAX_NAMESPACE_DEPTH = 2;
    private static final int NAMESPACE_ROOT_LEVEL = 0;
    private static final int NAMESPACE_DB_LEVEL = 1;
    private static final int NAMESPACE_SCHEMA_LEVEL = 2;

    private NamespaceHelpers() {
    }

    public static SnowflakeIdentifier toSnowflakeIdentifier(Namespace namespace) {
        switch (namespace.length()) {
            case 0: {
                return SnowflakeIdentifier.ofRoot();
            }
            case 1: {
                return SnowflakeIdentifier.ofDatabase(namespace.level(0));
            }
            case 2: {
                return SnowflakeIdentifier.ofSchema(namespace.level(0), namespace.level(1));
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Snowflake max namespace level is %d, got namespace '%s'", 2, namespace));
    }

    public static SnowflakeIdentifier toSnowflakeIdentifier(TableIdentifier identifier) {
        SnowflakeIdentifier namespaceScope = NamespaceHelpers.toSnowflakeIdentifier(identifier.namespace());
        Preconditions.checkArgument((namespaceScope.type() == SnowflakeIdentifier.Type.SCHEMA ? 1 : 0) != 0, (String)"Namespace portion of '%s' must be at the SCHEMA level, got namespaceScope '%s'", (Object)identifier, (Object)namespaceScope);
        return SnowflakeIdentifier.ofTable(namespaceScope.databaseName(), namespaceScope.schemaName(), identifier.name());
    }

    public static Namespace toIcebergNamespace(SnowflakeIdentifier identifier) {
        switch (identifier.type()) {
            case ROOT: {
                return Namespace.empty();
            }
            case DATABASE: {
                return Namespace.of((String[])new String[]{identifier.databaseName()});
            }
            case SCHEMA: {
                return Namespace.of((String[])new String[]{identifier.databaseName(), identifier.schemaName()});
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert identifier '%s' to Namespace", identifier));
    }

    public static TableIdentifier toIcebergTableIdentifier(SnowflakeIdentifier identifier) {
        Preconditions.checkArgument((identifier.type() == SnowflakeIdentifier.Type.TABLE ? 1 : 0) != 0, (String)"SnowflakeIdentifier must be type TABLE, got '%s'", (Object)identifier);
        return TableIdentifier.of((String[])new String[]{identifier.databaseName(), identifier.schemaName(), identifier.tableName()});
    }
}

