/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.snowflake;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;

class SnowflakeTableMetadata {
    public static final Pattern SNOWFLAKE_AZURE_PATTERN = Pattern.compile("azure://([^/]+)/([^/]+)/(.*)");
    private final String snowflakeMetadataLocation;
    private final String icebergMetadataLocation;
    private final String status;
    private final String rawJsonVal;

    SnowflakeTableMetadata(String snowflakeMetadataLocation, String icebergMetadataLocation, String status, String rawJsonVal) {
        this.snowflakeMetadataLocation = snowflakeMetadataLocation;
        this.icebergMetadataLocation = icebergMetadataLocation;
        this.status = status;
        this.rawJsonVal = rawJsonVal;
    }

    public String snowflakeMetadataLocation() {
        return this.snowflakeMetadataLocation;
    }

    public String icebergMetadataLocation() {
        return this.icebergMetadataLocation;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SnowflakeTableMetadata)) {
            return false;
        }
        SnowflakeTableMetadata that = (SnowflakeTableMetadata)o;
        return Objects.equal((Object)this.snowflakeMetadataLocation, (Object)that.snowflakeMetadataLocation) && Objects.equal((Object)this.icebergMetadataLocation, (Object)that.icebergMetadataLocation) && Objects.equal((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.snowflakeMetadataLocation, this.icebergMetadataLocation, this.status});
    }

    public String toString() {
        return String.format("snowflakeMetadataLocation: '%s', icebergMetadataLocation: '%s', status: '%s'", this.snowflakeMetadataLocation, this.icebergMetadataLocation, this.status);
    }

    public String toDebugString() {
        return String.format("%s, rawJsonVal: %s", this, this.rawJsonVal);
    }

    public static String snowflakeLocationToIcebergLocation(String snowflakeLocation) {
        if (snowflakeLocation.startsWith("azure://")) {
            Matcher matcher = SNOWFLAKE_AZURE_PATTERN.matcher(snowflakeLocation);
            Preconditions.checkArgument((boolean)matcher.matches(), (String)"Location '%s' failed to match pattern '%s'", (Object)snowflakeLocation, (Object)SNOWFLAKE_AZURE_PATTERN);
            return String.format("wasbs://%s@%s/%s", matcher.group(2), matcher.group(1), matcher.group(3));
        }
        if (snowflakeLocation.startsWith("gcs://")) {
            return "gs" + snowflakeLocation.substring(3);
        }
        return snowflakeLocation;
    }

    public static SnowflakeTableMetadata parseJson(String json) {
        JsonNode parsedVal;
        try {
            parsedVal = (JsonNode)JsonUtil.mapper().readValue(json, JsonNode.class);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(String.format("Malformed JSON: %s", json), ioe);
        }
        String snowflakeMetadataLocation = JsonUtil.getString((String)"metadataLocation", (JsonNode)parsedVal);
        String status = JsonUtil.getStringOrNull((String)"status", (JsonNode)parsedVal);
        String icebergMetadataLocation = SnowflakeTableMetadata.snowflakeLocationToIcebergLocation(snowflakeMetadataLocation);
        return new SnowflakeTableMetadata(snowflakeMetadataLocation, icebergMetadataLocation, status, json);
    }
}

