/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.fs;

import java.util.Objects;

public class FSPath {
    private final String path;
    private final long size;
    private long lastModified = -1L;

    public FSPath(String path) {
        assert (path.startsWith("/"));
        this.path = path;
        this.size = 0L;
    }

    public FSPath(String path, long size) {
        assert (path.startsWith("/"));
        this.path = path;
        this.size = size;
    }

    public FSPath(String path, long size, long lastModified) {
        assert (path.startsWith("/")) : "Path should start with a /: " + path;
        this.path = path;
        this.size = size;
        this.lastModified = lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public String path() {
        return this.path;
    }

    public String toString() {
        return this.path();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public static long totalSize(Iterable<FSPath> it) {
        long totalSize = 0L;
        for (FSPath f : it) {
            if (f.getSize() <= 0L) continue;
            totalSize += f.getSize();
        }
        return totalSize;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FSPath fsPath = (FSPath)o;
        return this.size == fsPath.size && this.lastModified == fsPath.lastModified && Objects.equals(this.path, fsPath.path);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.size, this.lastModified);
    }
}

