/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputWriter;
import java.io.IOException;
import java.io.OutputStream;

public class StreamOutputWriter
extends OutputWriter {
    private OutputStream outputStream;
    private ColumnFactory cf;
    private OutputFormatter formatter;

    public StreamOutputWriter(OutputStream outputStream, OutputFormatter formatter) {
        this.outputStream = outputStream;
        this.formatter = formatter;
    }

    @Override
    public void init(ColumnFactory cf) throws Exception {
        this.cf = cf;
        this.formatter.header(cf, this.outputStream);
    }

    @Override
    public void emitRow(Row row) throws Exception {
        this.formatter.format(row, this.cf, this.outputStream);
    }

    @Override
    public void lastRowEmitted() throws Exception {
        this.formatter.footer(this.cf, this.outputStream);
        this.outputStream.close();
    }

    @Override
    public void cancel() throws Exception {
        this.formatter.cancel(this.outputStream);
        this.outputStream.close();
    }

    @Override
    public long writtenBytes() throws IOException {
        return -1L;
    }
}

