/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.internal.util.Preconditions;
import java.util.Objects;
import java.util.Optional;

@Evolving
public class CollationIdentifier {
    private final String provider;
    private final String name;
    private final Optional<String> version;

    private CollationIdentifier(String string, String string2) {
        this(string, string2, Optional.empty());
    }

    private CollationIdentifier(String string, String string2, Optional<String> optional) {
        Objects.requireNonNull(string, "Collation provider cannot be null.");
        Objects.requireNonNull(string2, "Collation name cannot be null.");
        Objects.requireNonNull(optional, "Collation version cannot be null.");
        this.provider = string.toUpperCase();
        this.name = string2.toUpperCase();
        this.version = optional.map(String::toUpperCase);
    }

    public String getProvider() {
        return this.provider;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getVersion() {
        return this.version;
    }

    public static CollationIdentifier fromString(String string) {
        long l = string.chars().filter(n -> n == 46).count();
        Preconditions.checkArgument(l > 0L, "Invalid collation identifier: %s", string);
        if (l == 1L) {
            String[] stringArray = string.split("\\.");
            return new CollationIdentifier(stringArray[0], stringArray[1]);
        }
        String[] stringArray = string.split("\\.", 3);
        return new CollationIdentifier(stringArray[0], stringArray[1], Optional.of(stringArray[2]));
    }

    public boolean equals(Object object) {
        if (!(object instanceof CollationIdentifier)) {
            return false;
        }
        CollationIdentifier collationIdentifier = (CollationIdentifier)object;
        return this.provider.equals(collationIdentifier.provider) && this.name.equals(collationIdentifier.name) && this.version.equals(collationIdentifier.version);
    }

    public String toStringWithoutVersion() {
        return String.format("%s.%s", this.provider, this.name);
    }

    public String toString() {
        if (this.version.isPresent()) {
            return String.format("%s.%s.%s", this.provider, this.name, this.version.get());
        }
        return String.format("%s.%s", this.provider, this.name);
    }
}

