/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.export.writers;

import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.gh.core.services.export.ArtifactExportRow;
import com.dataiku.gh.core.services.export.writers.ArtifactExportWriterConfiguration;
import com.dataiku.gh.core.services.export.writers.IArtifactExportWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.springframework.util.CollectionUtils;

public class ArtifactExportCSVWriter
implements IArtifactExportWriter {
    private static final ArtifactExportWriterConfiguration CSV_CONFIG = new ArtifactExportWriterConfiguration(false, true, false, false, true);
    protected final StringWriter writer = new StringWriter();
    protected final CSVPrinter printer = new CSVPrinter((Appendable)this.writer, CSVFormat.DEFAULT);

    public ArtifactExportCSVWriter() throws IOException {
        this.printer.printRecord(new Object[]{"Type", "ID", "Label", "Value"});
    }

    @Override
    public ArtifactExportWriterConfiguration getConfig() {
        return CSV_CONFIG;
    }

    @Override
    public void writeRow(ArtifactExportRow exportRow) {
        Object value = CollectionUtils.isEmpty(exportRow.values) ? "" : (exportRow.values.size() == 1 ? exportRow.values.get(0) : "[" + String.join((CharSequence)", ", exportRow.values) + "]");
        try {
            this.printer.printRecord(Arrays.asList(exportRow.type, exportRow.id, exportRow.label, value));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public InputStream getStream() {
        return IOUtils.toInputStream((CharSequence)this.writer.getBuffer(), (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.printer.close();
    }
}

