/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.migration_paths;

import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionExport;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPathStatus;
import com.dataiku.gh.core.services.migration_paths.IAdminBlueprintVersionMigrationPathsService;
import com.dataiku.gh.core.services.migration_paths.IBlueprintVersionMigrationPathsDataService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IBlueprintVersionMigrationPathValidationService;
import com.dataiku.gh.core.services.validation.errors.MissingReferenceException;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.migration_paths.IBlueprintVersionMigrationPathDAO;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.security.IPermissionsService;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminBlueprintVersionMigrationPathsService
implements IAdminBlueprintVersionMigrationPathsService {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IBlueprintVersionMigrationPathsDataService blueprintVersionMigrationPathsDataService;
    @Autowired
    private IBlueprintVersionMigrationPathDAO blueprintVersionMigrationPathDAO;
    @Autowired
    private IBlueprintVersionMigrationPathValidationService blueprintVersionMigrationPathValidationService;

    @Override
    @GHReadonlyTransaction
    public List<BlueprintVersionMigrationPath> listBlueprintVersionMigrationPaths(AuthCtx authCtx) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.blueprintVersionMigrationPathsDataService.listBlueprintVersionMigrationPaths();
    }

    @Override
    @GHReadonlyTransaction
    public BlueprintVersionMigrationPath getBlueprintVersionMigrationPath(AuthCtx authCtx, String migrationPathId) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.blueprintVersionMigrationPathsDataService.getBlueprintVersionMigrationPath(migrationPathId);
    }

    @Override
    @GHWriteTransaction
    public BlueprintVersionMigrationPath createBlueprintVersionMigrationPath(AuthCtx authCtx, BlueprintVersionMigrationPath blueprintVersionMigrationPath, String newIdentifier) throws IOException, UnauthorizedException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.performMigrationPathCreation(blueprintVersionMigrationPath, newIdentifier);
    }

    @Override
    @GHWriteTransaction
    @Nullable
    public BlueprintVersionMigrationPath importBlueprintVersionMigrationPath(AuthCtx authCtx, BlueprintVersionMigrationPath blueprintVersionMigrationPath, String blueprintId, BlueprintVersionExport.MigrationPathImportBehavior migrationPathImportBehavior) throws IOException, UnauthorizedException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.performMigrationPathImport(blueprintVersionMigrationPath, blueprintId, migrationPathImportBehavior);
    }

    @Override
    @GHWriteTransaction
    public BlueprintVersionMigrationPath saveBlueprintVersionMigrationPath(AuthCtx authCtx, BlueprintVersionMigrationPath blueprintVersionMigrationPath, boolean dangerZoneAccepted) throws IOException, UnauthorizedException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.performBlueprintVersionMigrationPathSave(blueprintVersionMigrationPath, dangerZoneAccepted);
    }

    @Override
    @GHWriteTransaction
    public BlueprintVersionMigrationPath updateBlueprintVersionMigrationPathStatus(AuthCtx authCtx, String blueprintVersionMigrationPathId, BlueprintVersionMigrationPathStatus migrationPathStatus) throws UnauthorizedException, LimitsStatusComputer.LicenseLimitException, IOException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.performBlueprintVersionMigrationPathStatusUpdate(blueprintVersionMigrationPathId, migrationPathStatus);
    }

    @Override
    @GHWriteTransaction
    public void deleteBlueprintVersionMigrationPath(AuthCtx authCtx, String migrationPathId) throws IOException, UnauthorizedException, LimitsStatusComputer.LicenseLimitException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.blueprintVersionMigrationPathsDataService.deleteBlueprintVersionMigrationPath(migrationPathId);
    }

    private BlueprintVersionMigrationPath performMigrationPathCreation(BlueprintVersionMigrationPath blueprintVersionMigrationPath, String newIdentifier) throws IOException {
        if (blueprintVersionMigrationPath.id != null) {
            throw new ValidationException("blueprintVersionMigrationPath.id `" + blueprintVersionMigrationPath.id + "` cannot be set in creation");
        }
        if (blueprintVersionMigrationPath.status != BlueprintVersionMigrationPathStatus.DRAFT) {
            throw new ValidationException("Blueprint version migration path status must be set to DRAFT in creation, current status: " + String.valueOf((Object)blueprintVersionMigrationPath.status));
        }
        blueprintVersionMigrationPath.id = IdentifiersUtils.buildMigrationPathId(newIdentifier);
        if (this.blueprintVersionMigrationPathDAO.exists(blueprintVersionMigrationPath.id)) {
            throw new ValidationException("Blueprint version migration path ID already exists: " + blueprintVersionMigrationPath.id);
        }
        this.blueprintVersionMigrationPathValidationService.validateMigrationPath(blueprintVersionMigrationPath);
        return this.blueprintVersionMigrationPathsDataService.createBlueprintVersionMigrationPath(blueprintVersionMigrationPath);
    }

    private BlueprintVersionMigrationPath performBlueprintVersionMigrationPathSave(BlueprintVersionMigrationPath blueprintVersionMigrationPath, boolean dangerZoneAccepted) throws IOException {
        this.blueprintVersionMigrationPathValidationService.validateMigrationPath(blueprintVersionMigrationPath);
        if (!this.blueprintVersionMigrationPathDAO.exists(blueprintVersionMigrationPath.id)) {
            throw new NotFoundException("Cannot find migration path: " + blueprintVersionMigrationPath.id);
        }
        return this.blueprintVersionMigrationPathsDataService.saveBlueprintVersionMigrationPath(blueprintVersionMigrationPath, dangerZoneAccepted);
    }

    private BlueprintVersionMigrationPath performBlueprintVersionMigrationPathStatusUpdate(String blueprintVersionMigrationPathId, BlueprintVersionMigrationPathStatus migrationPathStatus) throws IOException {
        if (StringUtils.isBlank((String)blueprintVersionMigrationPathId)) {
            throw new ValidationException("blueprintVersionMigrationPathId is required");
        }
        if (migrationPathStatus == null) {
            throw new ValidationException("migrationPathStatus is required");
        }
        if (!this.blueprintVersionMigrationPathDAO.exists(blueprintVersionMigrationPathId)) {
            throw new NotFoundException("Blueprint version migration path not found: " + blueprintVersionMigrationPathId);
        }
        return this.blueprintVersionMigrationPathsDataService.updateBlueprintVersionMigrationPathStatus(blueprintVersionMigrationPathId, migrationPathStatus);
    }

    @Nullable
    private BlueprintVersionMigrationPath performMigrationPathImport(BlueprintVersionMigrationPath blueprintVersionMigrationPath, String blueprintId, BlueprintVersionExport.MigrationPathImportBehavior migrationPathImportBehavior) throws IOException {
        if (this.blueprintVersionMigrationPathDAO.exists(blueprintVersionMigrationPath.id)) {
            if (migrationPathImportBehavior == BlueprintVersionExport.MigrationPathImportBehavior.IGNORE_MIGRATION_ON_EXISTING_MIGRATION_OR_MISSING_VERSION) {
                return null;
            }
            throw new ValidationException("Blueprint version migration path ID already exists: " + blueprintVersionMigrationPath.id);
        }
        blueprintVersionMigrationPath.status = BlueprintVersionMigrationPathStatus.DRAFT;
        ValidatorUtils.validateThat(Objects.equals(blueprintId, blueprintVersionMigrationPath.blueprintVersionIdFrom.blueprintId), "Current blueprint ID should match the migration path blueprint ID", new Object[0]);
        try {
            this.blueprintVersionMigrationPathValidationService.validateMigrationPath(blueprintVersionMigrationPath);
        }
        catch (MissingReferenceException e) {
            if (migrationPathImportBehavior == BlueprintVersionExport.MigrationPathImportBehavior.IGNORE_MIGRATION_ON_EXISTING_MIGRATION_OR_MISSING_VERSION) {
                return null;
            }
            throw e;
        }
        return this.blueprintVersionMigrationPathsDataService.createBlueprintVersionMigrationPath(blueprintVersionMigrationPath);
    }
}

