/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.python_execution;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Stopwatch;
import com.dataiku.gh.core.models.actions.InstanceAction;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.Action;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.HookPhase;
import com.dataiku.gh.core.models.blueprints.LogicalHook;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.governance.AutoGovernanceScriptOutput;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.services.artifacts.IArtifactPatchupService;
import com.dataiku.gh.core.services.artifacts.IArtifactWorkflowService;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.context.EnrichedArtifactContext;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionKernelPool;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionService;
import com.dataiku.gh.core.services.python_execution.PythonExecutionRequest;
import com.dataiku.gh.core.services.python_execution.PythonExecutionResponse;
import com.dataiku.gh.core.services.python_execution.PythonExecutionStatus;
import com.dataiku.gh.core.services.python_execution.artifact_action.ArtifactActionScriptException;
import com.dataiku.gh.core.services.python_execution.artifact_action.ArtifactActionScriptRequest;
import com.dataiku.gh.core.services.python_execution.artifact_action.ArtifactActionScriptResponse;
import com.dataiku.gh.core.services.python_execution.autogovernance_script.AutoGovernanceScriptException;
import com.dataiku.gh.core.services.python_execution.autogovernance_script.AutoGovernanceScriptRequest;
import com.dataiku.gh.core.services.python_execution.autogovernance_script.AutoGovernanceScriptResponse;
import com.dataiku.gh.core.services.python_execution.instance_action.ActionScriptException;
import com.dataiku.gh.core.services.python_execution.instance_action.ActionScriptRequest;
import com.dataiku.gh.core.services.python_execution.instance_action.ActionScriptResponse;
import com.dataiku.gh.core.services.python_execution.logical_hooks.HooksExecutionResult;
import com.dataiku.gh.core.services.python_execution.logical_hooks.LogicalHookException;
import com.dataiku.gh.core.services.python_execution.logical_hooks.LogicalHookRequest;
import com.dataiku.gh.core.services.python_execution.logical_hooks.LogicalHookResponse;
import com.dataiku.gh.core.services.python_execution.migration_paths.MigrationPathException;
import com.dataiku.gh.core.services.python_execution.migration_paths.MigrationPathRequest;
import com.dataiku.gh.core.services.python_execution.migration_paths.MigrationPathResponse;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.TransactionUtils;
import com.dataiku.gh.core.services.validation.IArtifactValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.NeverForgettingQueue;
import com.dataiku.gh.security.GHAuthCtx;
import com.dataiku.gh.security.model.LegacyGlobalScopePublicAPIKey;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;

@Service
public class PythonExecutionService
implements IPythonExecutionService {
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private IArtifactValidationService artifactValidationService;
    @Autowired
    private IArtifactPatchupService artifactPatchupService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IArtifactWorkflowService artifactWorkflowService;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private IPythonExecutionKernelPool pythonExecutionKernelPool;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.python-execution");

    @Override
    public Artifact applyBlueprintVersionMigrationPath(EnrichedArtifact enrichedArtifactToMigrate, BlueprintVersionMigrationPath migration, EnrichedBlueprintVersion enrichedTargetBlueprintVersion, @Nullable String authCtxIdentifier) throws IOException {
        Artifact artifact;
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug(() -> "Blueprint version migration path started on the artifact: " + enrichedArtifactToMigrate.artifact.id + ", " + migration.id + ", " + enrichedTargetBlueprintVersion.blueprintVersion.id.toString());
        MigrationPathResponse resp = this.applyMigrationPath(migration, enrichedArtifactToMigrate, enrichedTargetBlueprintVersion, authCtxIdentifier);
        if (resp.status == PythonExecutionStatus.ERROR) {
            throw new MigrationPathException(resp.message, migration.id);
        }
        if (resp.migratedArtifact == null) {
            throw new MigrationPathException("The migration path did not return any artifact value", migration.id);
        }
        try {
            artifact = (Artifact)JSON.parse((String)resp.migratedArtifact, Artifact.class);
            if (!Objects.equals(artifact.id, enrichedArtifactToMigrate.artifact.id)) {
                logger.warn((Object)("The following migration path replaced the artifact ID: " + migration.id));
                artifact.id = enrichedArtifactToMigrate.artifact.id;
            }
            artifact.blueprintVersionId = migration.blueprintVersionIdTo;
            EnrichedArtifact newEnrichedArtifact = EnrichedArtifact.build(enrichedTargetBlueprintVersion.blueprint, enrichedTargetBlueprintVersion.blueprintVersion, enrichedTargetBlueprintVersion.blueprintVersionTrace, null, null, null, artifact, enrichedArtifactToMigrate.signoffs, enrichedArtifactToMigrate.enrichedArtifactDetails);
            artifact.workflow = this.artifactWorkflowService.prepareWorkflowForSaving(newEnrichedArtifact, artifact, true);
        }
        catch (JsonSyntaxException e) {
            throw new MigrationPathException("The following migration returned an invalid artifact value" + resp.migratedArtifact, migration.id, (Throwable)e);
        }
        logger.debug(() -> "Blueprint version migration path lasted " + stopwatch.elapsed().toMillis() + "ms on the artifact: " + enrichedArtifactToMigrate.artifact.id + ", " + migration.id + ", " + enrichedTargetBlueprintVersion.blueprintVersion.id.toString());
        this.updateAffectedArtifacts(null, Lists.newArrayList((Object[])new String[]{enrichedArtifactToMigrate.artifact.id}), enrichedArtifactToMigrate.artifact.id, authCtxIdentifier);
        return artifact;
    }

    @Override
    public AutoGovernanceScriptOutput applyScriptForAutoGovernance(EnrichedArtifact dkuEnrichedArtifact, String script) throws IOException {
        AutoGovernanceScriptOutput autoGovernanceScriptOutput;
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug(() -> "Auto governance script started on the artifact: " + dkuEnrichedArtifact.artifact.id);
        AutoGovernanceScriptResponse resp = this.applyAutoGovernanceScript(script, dkuEnrichedArtifact);
        if (resp.status == PythonExecutionStatus.ERROR) {
            throw new AutoGovernanceScriptException(resp.message, dkuEnrichedArtifact);
        }
        if (resp.scriptOutput == null) {
            throw new AutoGovernanceScriptException("The script did not return an autogovernance configuration to use", dkuEnrichedArtifact);
        }
        try {
            JsonObject jsonObject = (JsonObject)JSON.parse((String)resp.scriptOutput, JsonObject.class);
            if (jsonObject.has("childrenConfiguration")) {
                JsonObject childrenConfig = jsonObject.getAsJsonObject("childrenConfiguration");
                if (SystemProvidedConstants.DATAIKU_PROJECT.blueprintId.equals(dkuEnrichedArtifact.blueprint.id)) {
                    childrenConfig.addProperty("type", "project");
                } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId.equals(dkuEnrichedArtifact.blueprint.id)) {
                    childrenConfig.addProperty("type", "model");
                } else {
                    throw new ValidationException(String.format("artifact of `%s` and blueprint id `%s` cannot have a children configuration", dkuEnrichedArtifact.artifact.id, dkuEnrichedArtifact.blueprint.id));
                }
            }
            autoGovernanceScriptOutput = (AutoGovernanceScriptOutput)JSON.parse((String)jsonObject.toString(), AutoGovernanceScriptOutput.class);
        }
        catch (JsonSyntaxException e) {
            throw new AutoGovernanceScriptException("The autogovernance script returned an invalid configuration value: " + resp.scriptOutput, dkuEnrichedArtifact, (Throwable)e);
        }
        logger.debugV("Result of script governance on artifacts `%s` is `%s`", new Object[]{dkuEnrichedArtifact.artifact.id, autoGovernanceScriptOutput});
        logger.debug(() -> "Auto governance script lasted " + stopwatch.elapsed().toMillis() + "ms on the artifact: " + dkuEnrichedArtifact.artifact.id);
        return autoGovernanceScriptOutput;
    }

    @Override
    public ActionScriptResponse applyInstanceAction(InstanceAction action, String authCtxIdentifier, JsonObject params) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug(() -> "Action started: " + action.id);
        ActionScriptResponse resp = this.applyInstanceActionScript(action, authCtxIdentifier, params);
        if (resp.status == PythonExecutionStatus.ERROR) {
            throw new ActionScriptException(resp.message);
        }
        logger.debug(() -> "Action lasted " + stopwatch.elapsed().toMillis() + "ms: " + action.id);
        return resp;
    }

    @Override
    public ArtifactActionScriptResponse applyArtifactAction(String actionId, Action action, EnrichedArtifact enrichedArtifact, String authCtxIdentifier, JsonObject params) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug(() -> "Artifact action started on artifact: " + enrichedArtifact.artifact.id + ", " + actionId);
        ArtifactActionScriptResponse resp = this.applyArtifactActionScript(actionId, action, enrichedArtifact, authCtxIdentifier, params);
        if (resp.status == PythonExecutionStatus.ERROR) {
            throw new ArtifactActionScriptException(resp.message);
        }
        logger.debug(() -> "Artifact action lasted " + stopwatch.elapsed().toMillis() + "ms on artifact: " + enrichedArtifact.artifact.id + ", " + actionId);
        return resp;
    }

    @Override
    public HooksExecutionResult applyLogicalHooksForCreation(EnrichedArtifact newEnrichedArtifact, @Nullable String authCtxIdentifier) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug(() -> "Logical hooks (CREATE) started on the artifact: " + newEnrichedArtifact.artifact.id);
        HooksExecutionResult hooksExecutionResult = this.applyHooks(HookPhase.CREATE, this.getHookList(newEnrichedArtifact.blueprintVersion, HookPhase.CREATE), newEnrichedArtifact, null, authCtxIdentifier);
        logger.debug(() -> "Logical hooks (CREATE) lasted " + stopwatch.elapsed().toMillis() + "ms on the artifact: " + newEnrichedArtifact.artifact.id);
        this.updateAffectedArtifacts(hooksExecutionResult, newEnrichedArtifact.artifact.id, authCtxIdentifier);
        return hooksExecutionResult;
    }

    @Override
    public HooksExecutionResult applyLogicalHooksForUpdate(EnrichedArtifact newEnrichedArtifact, EnrichedArtifact existingEnrichedArtifact, @Nullable String authCtxIdentifier) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug(() -> "Logical hooks (UPDATE) started on the artifact: " + existingEnrichedArtifact.artifact.id);
        HooksExecutionResult hooksExecutionResult = this.applyHooks(HookPhase.UPDATE, this.getHookList(existingEnrichedArtifact.blueprintVersion, HookPhase.UPDATE), newEnrichedArtifact, existingEnrichedArtifact, authCtxIdentifier);
        logger.debug(() -> "Logical hooks (UPDATE) lasted " + stopwatch.elapsed().toMillis() + "ms on the artifact: " + existingEnrichedArtifact.artifact.id);
        this.updateAffectedArtifacts(hooksExecutionResult, newEnrichedArtifact.artifact.id, authCtxIdentifier);
        return hooksExecutionResult;
    }

    @Override
    public HooksExecutionResult applyLogicalHooksForDeletion(EnrichedArtifact existingEnrichedArtifact, @Nullable String authCtxIdentifier) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug(() -> "Logical hooks (DELETE) started on the artifact: " + existingEnrichedArtifact.artifact.id);
        HooksExecutionResult hooksExecutionResult = this.applyHooks(HookPhase.DELETE, this.getHookList(existingEnrichedArtifact.blueprintVersion, HookPhase.DELETE), null, existingEnrichedArtifact, authCtxIdentifier);
        logger.debug(() -> "Logical hooks (DELETE) lasted " + stopwatch.elapsed().toMillis() + "ms on the artifact: " + existingEnrichedArtifact.artifact.id);
        this.updateAffectedArtifacts(hooksExecutionResult, existingEnrichedArtifact.artifact.id, authCtxIdentifier);
        return hooksExecutionResult;
    }

    private MigrationPathResponse applyMigrationPath(BlueprintVersionMigrationPath migrationPath, EnrichedArtifact artifactToMigrate, EnrichedBlueprintVersion targetEnrichedBlueprintVersion, @Nullable String authCtxIdentifier) throws IOException {
        return this.applyPythonScript((ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException>)((ExceptionUtils.ThrowingSupplier)() -> this.createTicketForMigrationPath(migrationPath)), ticketSecret -> () -> new MigrationPathRequest((String)ticketSecret, migrationPath, artifactToMigrate, targetEnrichedBlueprintVersion, authCtxIdentifier), MigrationPathResponse.class);
    }

    private APITicketService.Ticket createTicketForMigrationPath(BlueprintVersionMigrationPath migration) throws IOException {
        String migrationIdentifier = "migration-path__" + migration.id;
        String apiKeyLabel = "API Key for migration path: " + migration.id;
        String apiKeyDesc = "API Key for migration migration: " + migration.name + ", " + migrationIdentifier;
        return this.createFakeAPIKeyAuthCtxFromIdentifiers(migrationIdentifier, apiKeyLabel, apiKeyDesc);
    }

    private AutoGovernanceScriptResponse applyAutoGovernanceScript(String script, EnrichedArtifact enrichedArtifact) throws IOException {
        return this.applyPythonScript((ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException>)((ExceptionUtils.ThrowingSupplier)this::createTicketForAutoGovernance), ticketSecret -> () -> new AutoGovernanceScriptRequest((String)ticketSecret, script, enrichedArtifact), AutoGovernanceScriptResponse.class);
    }

    private APITicketService.Ticket createTicketForAutoGovernance() throws IOException {
        String identifier = "autogovernance-script";
        String apiKeyLabel = "API Key for autogovernance-script";
        return this.createFakeAPIKeyAuthCtxFromIdentifiers(identifier, apiKeyLabel, apiKeyLabel);
    }

    private ActionScriptResponse applyInstanceActionScript(InstanceAction action, String authCtxIdentifier, JsonObject params) throws IOException {
        return this.applyPythonScript((ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException>)((ExceptionUtils.ThrowingSupplier)() -> this.createTicketForInstanceAction(action)), ticketSecret -> () -> new ActionScriptRequest(action.id, (String)ticketSecret, action.script, authCtxIdentifier, params), ActionScriptResponse.class);
    }

    private APITicketService.Ticket createTicketForInstanceAction(InstanceAction action) throws IOException {
        String actionIdentifier = "action__" + action.id;
        String apiKeyLabel = "API Key for action: " + action.name;
        String apiKeyDesc = "API Key for action: " + action.name + ", " + actionIdentifier;
        return this.createFakeAPIKeyAuthCtxFromIdentifiers(actionIdentifier, apiKeyLabel, apiKeyDesc);
    }

    private ArtifactActionScriptResponse applyArtifactActionScript(String actionId, Action action, EnrichedArtifact enrichedArtifact, String authCtxIdentifier, JsonObject params) throws IOException {
        return this.applyPythonScript((ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException>)((ExceptionUtils.ThrowingSupplier)() -> this.createTicketForArtifactAction(actionId, action, enrichedArtifact.artifact)), ticketSecret -> () -> new ArtifactActionScriptRequest(actionId, (String)ticketSecret, action.script, enrichedArtifact, authCtxIdentifier, params), ArtifactActionScriptResponse.class);
    }

    private APITicketService.Ticket createTicketForArtifactAction(String actionId, Action action, Artifact artifact) throws IOException {
        String actionIdentifier = "artifact-action__" + artifact.id + "__" + actionId;
        String apiKeyLabel = "API Key for action: " + action.name;
        String apiKeyDesc = "API Key for action: " + action.name + ", " + actionIdentifier;
        return this.createFakeAPIKeyAuthCtxFromIdentifiers(actionIdentifier, apiKeyLabel, apiKeyDesc);
    }

    private HooksExecutionResult applyHooks(HookPhase hookPhase, List<LogicalHook> hooksToApply, @Nullable EnrichedArtifact newEnrichedArtifact, @Nullable EnrichedArtifact existingEnrichedArtifact, @Nullable String authCtxIdentifier) throws IOException {
        ArrayList<String> artifactIdsToUpdate = new ArrayList<String>();
        if (hookPhase != HookPhase.DELETE) {
            this.artifactValidationService.validateArtifact(newEnrichedArtifact, existingEnrichedArtifact);
            this.artifactPatchupService.patchupArtifact(newEnrichedArtifact);
            if (newEnrichedArtifact != null) {
                newEnrichedArtifact.artifact.status.stepId = newEnrichedArtifact.artifact.getLegacyStepId(this.artifactWorkflowService.computeVisibleArtifactWorkflowSteps(newEnrichedArtifact));
            }
        }
        for (LogicalHook hook : hooksToApply) {
            LogicalHookResponse resp = this.applyPythonScript((ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException>)((ExceptionUtils.ThrowingSupplier)() -> this.createTicketForLogicalHook(hook, newEnrichedArtifact, existingEnrichedArtifact)), ticketSecret -> () -> new LogicalHookRequest((String)ticketSecret, hook, hookPhase, existingEnrichedArtifact, newEnrichedArtifact, authCtxIdentifier), LogicalHookResponse.class);
            if (resp.status == null) {
                throw new LogicalHookException("Unexpected error (logical hook did not return any statuses). Ask your administrator to investigate.", hook.name, existingEnrichedArtifact != null ? existingEnrichedArtifact : newEnrichedArtifact, resp.fieldMessages);
            }
            if (resp.status == PythonExecutionStatus.ERROR) {
                throw new LogicalHookException(resp.message, hook.name, existingEnrichedArtifact != null ? existingEnrichedArtifact : newEnrichedArtifact, resp.fieldMessages);
            }
            if (hookPhase != HookPhase.DELETE) {
                if (resp.artifact == null) {
                    throw new LogicalHookException("Unexpected error (logical hook removed the artifact value). Ask your administrator to investigate.", hook.name, existingEnrichedArtifact != null ? existingEnrichedArtifact : newEnrichedArtifact, resp.fieldMessages);
                }
                try {
                    Artifact artifact = (Artifact)JSON.parse((String)resp.artifact, Artifact.class);
                    if (!Objects.equals(artifact.id, newEnrichedArtifact.artifact.id)) {
                        logger.warn((Object)("The following logical hook replaced the artifact ID: " + newEnrichedArtifact.artifact.blueprintVersionId.toString() + ", " + hook.name));
                        artifact.id = newEnrichedArtifact.artifact.id;
                    }
                    if (!Objects.equals(artifact.blueprintVersionId, newEnrichedArtifact.artifact.blueprintVersionId)) {
                        logger.warn((Object)("The following logical hook replaced the artifact blueprintVersion ID: " + newEnrichedArtifact.artifact.blueprintVersionId.toString() + ", " + hook.name));
                        artifact.blueprintVersionId = newEnrichedArtifact.artifact.blueprintVersionId;
                    }
                    this.setHookArtifactWithWorkflow(existingEnrichedArtifact, newEnrichedArtifact, artifact);
                }
                catch (JsonSyntaxException e) {
                    throw new LogicalHookException("Unexpected error (logical hook returned an unparsable artifact value). Ask your administrator to investigate.", hook.name, existingEnrichedArtifact != null ? existingEnrichedArtifact : newEnrichedArtifact, resp.fieldMessages, e);
                }
                try {
                    this.artifactValidationService.validateArtifact(newEnrichedArtifact, existingEnrichedArtifact);
                }
                catch (ValidationException e) {
                    throw new LogicalHookException("Unexpected error (logical hook returned an invalid artifact). Ask your administrator to investigate.", hook.name, existingEnrichedArtifact != null ? existingEnrichedArtifact : newEnrichedArtifact, null, e);
                }
                this.artifactPatchupService.patchupArtifact(newEnrichedArtifact);
            }
            artifactIdsToUpdate.addAll(resp.artifactIdsToUpdate);
        }
        return HooksExecutionResult.build(newEnrichedArtifact, artifactIdsToUpdate);
    }

    private APITicketService.Ticket createTicketForLogicalHook(LogicalHook hook, @Nullable EnrichedArtifact newEnrichedArtifact, @Nullable EnrichedArtifact existingEnrichedArtifact) throws IOException {
        Optional<EnrichedArtifact> anyEnrichedArtifact = Optional.ofNullable(Optional.ofNullable(existingEnrichedArtifact).orElse(newEnrichedArtifact));
        Optional<String> blueprintVersionName = anyEnrichedArtifact.map(ea -> ea.blueprint.name + (String)(StringUtils.isNotBlank((CharSequence)ea.blueprintVersion.name) ? " (" + ea.blueprintVersion.name + ")" : ""));
        Optional<String> blueprintVersionId = anyEnrichedArtifact.map(ea -> ea.blueprintVersion.id.blueprintId + "-" + ea.blueprintVersion.id.versionId);
        String hookIdentifier = "logical-hook__" + blueprintVersionId.map(s -> s + "__").orElse("") + hook.name;
        String apiKeyLabel = "API Key for logical hook: " + hook.name;
        String apiKeyDesc = "API Key for logical hook: " + blueprintVersionName.map(s -> s + ", ").orElse("") + hook.name + ", " + hookIdentifier;
        return this.createFakeAPIKeyAuthCtxFromIdentifiers(hookIdentifier, apiKeyLabel, apiKeyDesc);
    }

    private void setHookArtifactWithWorkflow(EnrichedArtifact existingEnrichedArtifact, EnrichedArtifact newEnrichedArtifact, Artifact hookArtifact) {
        try (EnrichedArtifactContext.EnrichedArtifactContextContainer enrichedArtifactContext = EnrichedArtifactContext.attachNewContextOrKeepExistingOne();){
            String legacyStepId = newEnrichedArtifact.artifact.status.stepId;
            if (!Objects.equals(hookArtifact.status.stepId, legacyStepId)) {
                newEnrichedArtifact.artifact = hookArtifact;
                hookArtifact.workflow = this.artifactWorkflowService.getArtifactWorkflowFromInputStepId(existingEnrichedArtifact, newEnrichedArtifact);
            } else {
                hookArtifact.workflow = this.artifactWorkflowService.prepareWorkflowForSaving(newEnrichedArtifact, hookArtifact, true);
                newEnrichedArtifact.artifact = hookArtifact;
            }
        }
    }

    private void updateAffectedArtifacts(HooksExecutionResult hooksExecutionResult, String contextualArtifactId, @Nullable String authCtxIdentifier) {
        this.updateAffectedArtifacts(hooksExecutionResult.newEnrichedArtifact != null ? hooksExecutionResult.newEnrichedArtifact.artifact.id : null, hooksExecutionResult.artifactIdsToUpdate, contextualArtifactId, authCtxIdentifier);
    }

    private List<LogicalHook> getHookList(BlueprintVersion blueprintVersion, HookPhase hookPhase) {
        return blueprintVersion.logicalHookList.stream().filter(hook -> hook.phases.contains((Object)hookPhase)).collect(Collectors.toList());
    }

    private void updateAffectedArtifacts(@Nullable String artifactIdToIgnore, List<String> artifactIdsToUpdate, String contextualArtifactId, @Nullable String authCtxIdentifier) {
        if (CollectionUtils.isEmpty(artifactIdsToUpdate)) {
            return;
        }
        TransactionUtils.executeAfterCommitWithinNewTransaction(this.transactionManager, () -> {
            NeverForgettingQueue<String> toUpdate = new NeverForgettingQueue<String>();
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                String artifactId;
                if (StringUtils.isNotBlank((CharSequence)artifactIdToIgnore)) {
                    toUpdate.add(artifactIdToIgnore);
                    toUpdate.poll();
                }
                toUpdate.addAll(artifactIdsToUpdate);
                logger.debug(() -> "Queue of artifactIdsToUpdate started as a result of python script execution triggered by artifact \"" + contextualArtifactId + "\": " + String.join((CharSequence)",", artifactIdsToUpdate));
                while ((artifactId = (String)toUpdate.poll()) != null) {
                    try {
                        EnrichedArtifact affectedArtifact = this.artifactsDataService.getArtifact(artifactId);
                        HooksExecutionResult affectedArtifactHooksExecutionResult = this.applyHooks(HookPhase.UPDATE, this.getHookList(affectedArtifact.blueprintVersion, HookPhase.UPDATE), affectedArtifact, affectedArtifact, authCtxIdentifier);
                        this.artifactsDataService.storeArtifact(affectedArtifactHooksExecutionResult.newEnrichedArtifact, false);
                        Set<String> addedArtifactIds = toUpdate.addAllAndReturnAdded(affectedArtifactHooksExecutionResult.artifactIdsToUpdate);
                        if (!CollectionUtils.isNotEmpty(addedArtifactIds)) continue;
                        logger.debug((Object)("IDs added to the queue of artifactIdsToUpdate as a result of logical hooks execution of phase \"" + String.valueOf((Object)HookPhase.UPDATE) + "\" in artifact \"" + artifactId + "\": " + String.join((CharSequence)",", addedArtifactIds)));
                    }
                    catch (NotFoundException e) {
                        logger.info((Object)("Artifact " + artifactId + " was not found while trying to apply hooks for artifact " + artifactIdToIgnore + ".This can happen if " + artifactId + " was deleted while those hooks were being applied."));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Your action has been successfully executed, however there was a problem while running dependent hooks. It is possible that some dependent items were not correctly updated. Reload the page to have the latest changes. If the problem persists, please write down the artifact id (" + contextualArtifactId + ")  and contact your administrator.", e);
            }
            finally {
                logger.debug((Object)("Queue of artifactIdsToUpdate logical hooks execution lasted " + stopwatch.elapsed().toMillis() + " ms as a result of logical hook execution of \"" + contextualArtifactId + "\""));
            }
        });
    }

    private APITicketService.Ticket createFakeAPIKeyAuthCtxFromIdentifiers(String apiKeyId, String apiKeyLabel, String apiKeyDescription) throws IOException {
        LegacyGlobalScopePublicAPIKey publicAPIAPIKey = new LegacyGlobalScopePublicAPIKey();
        publicAPIAPIKey.id = apiKeyId;
        publicAPIAPIKey.label = apiKeyLabel;
        publicAPIAPIKey.description = apiKeyDescription;
        publicAPIAPIKey.createdBy = apiKeyId;
        publicAPIAPIKey.createdOn = System.currentTimeMillis();
        publicAPIAPIKey.getGlobalPermissions().setGovernArchitect(true);
        GHAuthCtx publicAPIAuthCtx = GHAuthCtx.forAPIKey(publicAPIAPIKey);
        return this.apiTicketService.createTicket((AuthCtx)publicAPIAuthCtx, apiKeyId, (Object)this).withRefreshableAuthCtx(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <REQ extends PythonExecutionRequest, RESP extends PythonExecutionResponse> RESP applyPythonScript(ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException> ticketSupplier, Function<String, Supplier<REQ>> requestSupplierTicketFunction, Class<RESP> responseClass) throws IOException {
        APITicketService.Ticket ticket = null;
        try {
            ticket = (APITicketService.Ticket)ticketSupplier.get();
            Supplier<REQ> requestSupplier = requestSupplierTicketFunction.apply(ticket.getSecret());
            RESP RESP = this.pythonExecutionKernelPool.executePythonScript(requestSupplier, responseClass);
            return RESP;
        }
        finally {
            if (ticket != null) {
                this.apiTicketService.expireTicket(ticket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <REQ extends PythonExecutionRequest, RESP extends PythonExecutionResponse> RESP applyPythonScriptsSequentially(ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException> ticketSupplier, Class<REQ> requestClass, Function<String, ExceptionUtils.ThrowingSupplier<REQ, IOException>> requestsSupplierTicketFunction, Class<RESP> responseClass, ExceptionUtils.ThrowingConsumer<IPythonExecutionKernelPool.RequestResponseData<REQ, RESP>, IOException> postResponseConsumer, Object executionLoggingObject) throws IOException {
        APITicketService.Ticket ticket = null;
        try {
            ticket = (APITicketService.Ticket)ticketSupplier.get();
            RESP RESP = this.pythonExecutionKernelPool.executePythonScriptsSequentially(requestClass, requestsSupplierTicketFunction.apply(ticket.getSecret()), responseClass, postResponseConsumer, executionLoggingObject);
            return RESP;
        }
        finally {
            if (ticket != null) {
                this.apiTicketService.expireTicket(ticket);
            }
        }
    }
}

