/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.relationships.permissions;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.relationships.AttachmentRelationshipData;
import com.dataiku.gh.core.models.relationships.FieldRelationshipData;
import com.dataiku.gh.core.models.relationships.Relationship;
import com.dataiku.gh.core.models.relationships.RelationshipEntity;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.relationships.handlers.IRelationshipHandler;
import com.dataiku.gh.core.services.relationships.permissions.IRelationshipPermissionService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.visitors.IRelationshipVisitor;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRelationshipPermissionService<T extends Relationship, U extends RelationshipEntity>
implements IRelationshipPermissionService<U> {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.relationship-permissions");
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IPermissionsService permissionsService;

    @Override
    @GHMandatoryTransaction
    public void checkRelationshipReadPermission(AuthCtx authCtx, U relationshipEntity) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        this.checkRelationshipPermission(authCtx, relationshipEntity, PermissionType.READ);
    }

    @Override
    @GHMandatoryTransaction
    public void checkRelationshipReadPermission_NoLicenseCheck(AuthCtx authCtx, U relationshipEntity) throws IOException, DKUSecurityException {
        this.checkRelationshipPermission(authCtx, relationshipEntity, PermissionType.READ);
    }

    @Override
    @GHMandatoryTransaction
    public void checkRelationshipWritePermission(AuthCtx authCtx, U relationshipEntity) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        this.checkRelationshipPermission(authCtx, relationshipEntity, PermissionType.WRITE);
    }

    protected abstract IRelationshipHandler<T> getHandler();

    private void checkRelationshipPermission(AuthCtx authCtx, U relationshipEntity, PermissionType permissionType) throws IOException, UnauthorizedException {
        if (this.permissionsService.isGovernArchitect(authCtx)) {
            return;
        }
        List<T> relationships = this.getHandler().getRelationshipsByEntityId(relationshipEntity.getId());
        if (relationships.isEmpty()) {
            if (!Objects.equals(authCtx.getIdentifier(), relationshipEntity.getOwner())) {
                if (permissionType == PermissionType.READ) {
                    throw new UnauthorizedException("You don't have read permission on this item: " + relationshipEntity.getId(), "item-read-denied");
                }
                if (permissionType == PermissionType.WRITE) {
                    throw new UnauthorizedException("You don't have write permission on this item: " + relationshipEntity.getId(), "item-write-denied");
                }
            }
        } else {
            List enrichedArtifacts;
            HashMap<String, AssignedRolesAndPermissionsCtx> cachedPermissionsByArtifactId = new HashMap<String, AssignedRolesAndPermissionsCtx>();
            try (Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), Collections.singletonList(ArtifactFilter.ArtifactsArtifactFilter.build(relationships.stream().map(Relationship::getArtifactId).distinct().collect(Collectors.toList()))), null, null);){
                enrichedArtifacts = searchResults.collect(Collectors.toList());
            }
            for (EnrichedArtifact enrichedArtifact : enrichedArtifacts) {
                if (cachedPermissionsByArtifactId.containsKey(enrichedArtifact.artifact.id)) continue;
                cachedPermissionsByArtifactId.put(enrichedArtifact.artifact.id, this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact));
            }
            for (Relationship relationship : relationships) {
                AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = (AssignedRolesAndPermissionsCtx)cachedPermissionsByArtifactId.get(relationship.getArtifactId());
                if (assignedRolesAndPermissionsCtx == null) {
                    if (permissionType == PermissionType.READ) {
                        throw new UnauthorizedException("You don't have read permission on this item: " + relationshipEntity.getId(), "item-read-denied");
                    }
                    if (permissionType == PermissionType.WRITE) {
                        throw new UnauthorizedException("You don't have write permission on this item: " + relationshipEntity.getId(), "item-write-denied");
                    }
                }
                PermissionCheckerVisitor permissionCheckerVisitor = new PermissionCheckerVisitor(this.checkPermissionsService, assignedRolesAndPermissionsCtx);
                relationship.accept(permissionCheckerVisitor);
                if (permissionType == PermissionType.READ && !permissionCheckerVisitor.hasReadPermission) {
                    throw new UnauthorizedException("You don't have read right on this item: " + relationship.getEntityId(), "artifact-read-denied");
                }
                if (permissionType != PermissionType.WRITE || permissionCheckerVisitor.hasWritePermission) continue;
                throw new UnauthorizedException("You don't have write right on this item: " + relationship.getEntityId(), "artifact-write-denied");
            }
        }
    }

    private static enum PermissionType {
        READ,
        WRITE;

    }

    private static class PermissionCheckerVisitor
    implements IRelationshipVisitor {
        private final ICheckPermissionsService governPermissionsService;
        private final AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx;
        public boolean hasReadPermission = false;
        public boolean hasWritePermission = false;

        private PermissionCheckerVisitor(ICheckPermissionsService governPermissionsService, AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx) {
            this.governPermissionsService = governPermissionsService;
            this.assignedRolesAndPermissionsCtx = assignedRolesAndPermissionsCtx;
        }

        @Override
        public void visit(AttachmentRelationshipData relationshipData, Object value) {
            this.hasReadPermission = this.governPermissionsService.hasArtifactReadPermission_NoLicenseCheck(this.assignedRolesAndPermissionsCtx.effectivePermissionsItem);
            this.hasWritePermission = this.governPermissionsService.hasArtifactWritePermission_NoLicenseCheck(this.assignedRolesAndPermissionsCtx.effectivePermissionsItem);
        }

        @Override
        public void visit(FieldRelationshipData relationshipData, Object value) {
            this.hasReadPermission = this.governPermissionsService.hasFieldReadPermission_NoLicenseCheck(this.assignedRolesAndPermissionsCtx.effectivePermissionsItem, relationshipData.fieldId);
            this.hasWritePermission = this.governPermissionsService.hasFieldWritePermissionForWrite_NoLicenseCheck(this.assignedRolesAndPermissionsCtx.effectivePermissionsItem, relationshipData.fieldId);
        }
    }
}

