/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.reports.ReportsManagementService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.APIAuthUtilsBase;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.security.ldap.LdapSettings;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.LdapTestService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.op.OIDCProviderConfigurationRequest;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.security.PublicGlobalAPIKey;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.maintainance.InstanceInfoService;
import com.dataiku.gh.reports.ReflectedEventsService;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.dataiku.gh.security.auth.UIAuthService;
import com.dataiku.gh.security.azure.GHAzureADUserSupplier;
import com.dataiku.gh.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import com.dataiku.gh.server.notifications.backend.GeneralSettingsChangedEvent;
import com.dataiku.gh.server.services.GeneralSettingsService;
import com.dataiku.gh.server.services.GraphiteReportingService;
import com.dataiku.gh.server.services.UsersService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ConfigurationController
extends DIPInternalControllerBase {
    @Autowired
    private PublicAPIKeysService publicApiKeyService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private MetaAuthService metaAuthService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private LdapTestService ldapTestService;
    @Autowired
    private ReportsManagementService reportsManagementService;
    @Autowired
    private ReflectedEventsService reflectedEventsService;
    @Autowired
    private InstanceInfoService instanceInfoService;
    @Autowired
    private GraphiteReportingService graphiteReportingService;
    @Autowired
    private AuditTrailService auditService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private GeneralSettingsDAO gsDAO;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private UserAuthenticationService userAuthenticationService;
    @Autowired
    private UsersService usersService;
    private static final Logger logger = Logger.getLogger(ConfigurationController.class);

    public void verifyPreRegistrationAuth(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        if (!ApplicationConfigurator.getParams().getBoolParam("dku.registration.preRegistrationAuthentication", false)) {
            return;
        }
        String expectedLogin = ApplicationConfigurator.getParams().getParam("dku.registration.preRegistrationLogin", "");
        String expectedPass = ApplicationConfigurator.getParams().getParam("dku.registration.preRegistrationPassword", "");
        APIAuthUtilsBase.BasicCredential lp = HTTPClientUtils.decodeAuth((HttpServletRequest)req);
        boolean authOK = true;
        if (lp == null || !StringUtils.isBlank((String)expectedLogin) && !expectedLogin.equals(lp.user) || !StringUtils.isBlank((String)expectedPass) && !expectedPass.equals(lp.password)) {
            authOK = false;
        }
        if (!authOK) {
            String realm = ApplicationConfigurator.getParams().getParam("dku.registration.preRegistrationRealm", "DSS pre-register auth");
            resp.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
            resp.sendError(401, "Authentication required");
            throw new SecurityException("Pre-authentication failed");
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/ping"})
    public void ping(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)JF.obj().with("pong", Boolean.valueOf(true)).get());
    }

    @AuditedCall(value={"msgType", "application-open"})
    @RequestMapping(value={"/api/get-configuration"})
    public void getConfiguration(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        GeneralSettingsService.AppConfig c;
        try (Transaction t = this.transactionService.beginRead();){
            c = this.generalSettingsService.getConfigurationInternal(req, resp);
            if (c.licensingMode == DKUApp.LicensingMode.NONE) {
                this.verifyPreRegistrationAuth(req, resp);
            }
        }
        catch (Exception e) {
            ConfigurationController.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
            return;
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)c);
    }

    @AuditedCall(value={"msgType", "admin-read-settings"})
    @RequestMapping(value={"/api/admin/get-general-settings"})
    public void getGeneralSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        GeneralSettingsDAO.GeneralSettings generalSettings;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            RelFile f = RelFile.global((String)"general-settings.json");
            generalSettings = (GeneralSettingsDAO.GeneralSettings)t.readObjectDefault(f, GeneralSettingsDAO.GeneralSettings.class);
        }
        catch (Exception e) {
            ConfigurationController.callFailed((Throwable)e, (HttpServletRequest)req, (HttpServletResponse)resp);
            return;
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)generalSettings);
    }

    @AuditedCall(value={"msgType", "fetch-openid-config"})
    @RequestMapping(value={"/api/admin/fetch-openid-config"})
    public void fetchOpenIDConfig(HttpServletRequest req, HttpServletResponse resp, String wellKnownURL) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        OIDCProviderConfigurationRequest request = new OIDCProviderConfigurationRequest(new Issuer(wellKnownURL.replace("/.well-known/openid-configuration", "")));
        HTTPRequest httpRequest = request.toHTTPRequest();
        httpRequest.setProxy(ApplicationConfigurator.getProxySettings().getProxy());
        try {
            HTTPResponse httpResponse = httpRequest.send();
            resp.setStatus(httpResponse.getStatusCode());
            ConfigurationController.writeJSONString((HttpServletResponse)resp, (String)httpResponse.getContent());
        }
        catch (Exception e) {
            logger.error((Object)("Can't retrieve well known endpoint " + request.getEndpointURI().toString()), (Throwable)e);
            ConfigurationController.callFailed((Throwable)new ApplicativeException("Invalid well-known", "Can't retrieve well known endpoint " + request.getEndpointURI().toString() + ". Logs may contain more details."), (HttpServletRequest)req, (HttpServletResponse)resp);
        }
    }

    @AuditedCall(value={"msgType", "admin-save-settings"})
    @RequestMapping(value={"/api/admin/save-general-settings"})
    public void saveGeneralSettings(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        GeneralSettingsDAO.GeneralSettings gs = (GeneralSettingsDAO.GeneralSettings)JSON.parse((String)data, GeneralSettingsDAO.GeneralSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            GeneralSettingsChangedEvent changeEvent = this.generalSettingsService.save(authCtx, gs);
            t.commit("Updated general settings");
        }
        t = this.transactionService.beginRead();
        try {
            this.graphiteReportingService.restartReporterIfNeeded();
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)messages);
    }

    @AuditedCall(value={"msgType", "invalidate-config-cache", "path", "${path}"})
    @RequestMapping(value={"api/admin/invalidate-config-cache"})
    public void invalidateConfigCache(HttpServletRequest req, HttpServletResponse resp, String path) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        this.transactionService.invalidateCache(RelFile.fromPath((String)path));
    }

    @AuditedCall(value={"msgType", "admin-get-instance-info"})
    @RequestMapping(value={"/api/admin/get-instance-info"})
    @ResponseBody
    public InstanceInfoService.InstanceInfo getInstanceInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        return this.instanceInfoService.get(true);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pop-next-report"})
    public void getNextReport(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUserNoXSRF(req);
        }
        ReportsManagementService.ReadyReport rr = this.reportsManagementService.popNextReport();
        if (rr == null) {
            ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)new JsonObject());
        } else {
            ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)rr.cloneWithoutPrivateInfo());
        }
    }

    @RequestMapping(value={"/api/pop-reflected-events"})
    public void popReflectedEvents(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)this.reflectedEventsService.popBatchToSend());
    }

    @AuditedCall(value={"msgType", "admin-ldap-test"})
    @RequestMapping(value={"/api/admin/test-ldap-settings"})
    public void testLdapSettings(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        LdapTestService.LdapTestSettingsResult res;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            LdapSettings settings = (LdapSettings)JSON.parse((String)data, LdapSettings.class);
            res = this.ldapTestService.testSettings(settings);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditedCall(value={"msgType", "admin-azure-ad-test"})
    @RequestMapping(value={"/api/admin/test-azure-ad-settings"})
    public void testAzureADSettings(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        AzureADTestSettingsResult res;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            TestAzureADSettings testAzureADSettings = (TestAzureADSettings)JSON.parse((String)data, TestAzureADSettings.class);
            GHAzureADUserSupplier dssAzureADUserSupplier = new GHAzureADUserSupplier(this.passwordEncryptionService, testAzureADSettings.azureADSettings);
            UserAttributes userAttributes = dssAzureADUserSupplier.getUserAttributes(testAzureADSettings.userIdentity);
            userAttributes.dkuGroupNames = this.userAuthenticationService.toDkuGroups(userAttributes, UserSourceType.AZURE_AD);
            res = new AzureADTestSettingsResult(userAttributes);
        }
        catch (Exception e) {
            logger.info((Object)"Testing Azure AD failed", (Throwable)e);
            res = new AzureADTestSettingsResult(new SerializedError((Throwable)e, false));
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditedCall(value={"msgType", "admin-ldap-test-user-details"})
    @RequestMapping(value={"/api/admin/test-ldap-get-user-details"})
    public void testLdapGetUserDetails(HttpServletRequest req, HttpServletResponse resp, String data) throws Exception {
        LdapTestService.LdapTestUserResult res;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            LdapTestService.LdapRequest ldapRequest = (LdapTestService.LdapRequest)JSON.parse((String)data, LdapTestService.LdapRequest.class);
            res = this.ldapTestService.getUserDetails(ldapRequest);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditedCall(value={"msgType", "admin-read-apikeys"})
    @RequestMapping(value={"/api/admin/publicapi/get-global-keys"})
    public void getGlobalKeys(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<AbstractGlobalScopePublicAPIKey> keys;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            keys = this.publicApiKeyService.listGlobalAPIKeys();
            keys.forEach(AbstractGlobalScopePublicAPIKey::clearManagedKeyField);
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, keys);
    }

    @AuditedCall(value={"msgType", "admin-read-apikeys"})
    @RequestMapping(value={"/api/admin/publicapi/get-global-key"})
    public void getGlobalKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String keyId) throws Exception {
        AbstractGlobalScopePublicAPIKey globalAPIKey;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            globalAPIKey = this.publicApiKeyService.getGlobalAPIKeyById(keyId);
            globalAPIKey.clearManagedKeyField();
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)((Object)globalAPIKey));
    }

    @AuditedCall(value={"msgType", "admin-read-apikeys"})
    @RequestMapping(value={"/api/admin/publicapi/get-global-key-details"})
    public void getGlobalKeyDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String key) throws IOException, DKUSecurityException {
        AbstractGlobalScopePublicAPIKey validApiKey = null;
        String decryptedKey = this.passwordEncryptionService.decryptIfEncrypted(key);
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            PublicAPIKey apiKey = this.publicApiKeyService.getKey(decryptedKey);
            if (apiKey instanceof AbstractGlobalScopePublicAPIKey) {
                validApiKey = (AbstractGlobalScopePublicAPIKey)apiKey;
                validApiKey.clearManagedKeyField();
            }
        }
        if (validApiKey == null) {
            throw ErrorContext.iae((String)"Global API Key does not exist");
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)((Object)validApiKey));
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/publicapi/create-global-key"})
    @GovernAction(value=ActionType.GLOBAL_API_KEY_CREATE)
    public void createGlobalKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String key) throws Exception {
        AbstractGlobalScopePublicAPIKey keyObj2;
        AbstractGlobalScopePublicAPIKey keyObj = (AbstractGlobalScopePublicAPIKey)((Object)JSON.parse((String)key, AbstractGlobalScopePublicAPIKey.class));
        if (StringUtils.isBlank((String)keyObj.label)) {
            throw ErrorContext.iae((String)"API key must have a label");
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            keyObj2 = this.publicApiKeyService.createGlobalAPIKey(keyObj);
            keyObj2.clearManagedKeyField();
            t.commit("Created new public API Key, id: " + keyObj2.id);
            this.auditService.generic("admin-publicapi-key-create").with("id", keyObj2.id).emit();
        }
        ConfigurationController.writeJSON((HttpServletResponse)resp, (Object)((Object)keyObj2));
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/publicapi/save-global-key"})
    @GovernAction(value=ActionType.GLOBAL_API_KEY_SAVE)
    public void saveGlobalKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String key) throws Exception {
        AbstractGlobalScopePublicAPIKey keyObj = (AbstractGlobalScopePublicAPIKey)((Object)JSON.parse((String)key, AbstractGlobalScopePublicAPIKey.class));
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.publicApiKeyService.updateGlobalAPIKeyById(keyObj);
            t.commit("Updated public API Key, id:" + keyObj.id);
            this.auditService.generic("admin-publicapi-key-save").with("id", keyObj.id).emit();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/publicapi/delete-global-key"})
    @GovernAction(value=ActionType.GLOBAL_API_KEY_DELETE)
    public void deleteGlobalKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String keyId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            AbstractGlobalScopePublicAPIKey foundKey = this.publicApiKeyService.deleteGlobalAPIKeyById(keyId);
            t.commit("Deleted public API Key, id:" + foundKey.id);
            this.auditService.generic("admin-publicapi-key-delete").with("id", foundKey.id).emit();
        }
    }

    @AuditedCall(value={"msgType", "admin-update-apikeys-lifetime"})
    @RequestMapping(value={"/api/admin/publicapi/update-api-keys-lifetime"})
    public void updateApiKeysLifetime(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.publicApiKeyService.updateApiKeysLifetime();
            t.commit("Update existing API Keys lifetime");
        }
    }

    @AuditedCall(value={"msgType", "read-apikeys"})
    @RequestMapping(value={"/api/publicapi/get-global-keys"})
    public void getPublicGlobalKeys(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            GeneralSettingsDAO.GeneralSettings gs = this.generalSettingsService.read();
            List apiKeys = Collections.emptyList();
            if (!gs.security.restrictUsersAndGroupsVisibility || user.isAdmin()) {
                apiKeys = this.publicApiKeyService.listGlobalAPIKeys().stream().map(PublicGlobalAPIKey::build).collect(Collectors.toList());
            }
            ConfigurationController.writeJSON((HttpServletResponse)resp, apiKeys);
        }
    }

    public static class TestAzureADSettings {
        public AzureADSettings azureADSettings;
        public UserIdentity userIdentity;
    }

    public class AzureADTestSettingsResult {
        public boolean connectionOK;
        public SerializedError connectionError;
        public UserAttributes userAttributes;

        public AzureADTestSettingsResult(UserAttributes userAttributes) {
            this.connectionOK = true;
            this.userAttributes = userAttributes;
        }

        public AzureADTestSettingsResult(SerializedError connectionError) {
            this.connectionOK = false;
            this.connectionError = connectionError;
        }
    }
}

