/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.services;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LogsService {
    static File logsFolder = new File(System.getenv("DIP_HOME"), "run");
    static File pythonScriptsLogFolder = new File(logsFolder, "python-scripts");
    private static DKULogger logger = DKULogger.getLogger((String)"dku.logs");

    public void streamLogs(String logName, boolean zipped, OutputStream out) throws IOException {
        this.streamLogs(logsFolder, logName, zipped, out);
    }

    public void streamPythonScriptLogs(String logName, boolean zipped, OutputStream out) throws IOException {
        this.streamLogs(pythonScriptsLogFolder, logName, zipped, out);
    }

    private void streamLogs(File rootDir, String logName, boolean zipped, OutputStream out) throws IOException {
        if (StringUtils.isNotBlank((String)logName)) {
            File logFile = DKUFileUtils.getWithin((File)rootDir, (String[])new String[]{logName});
            if (!zipped) {
                try (FileInputStream in = new FileInputStream(logFile);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            } else {
                this.zip(logFile, out);
            }
        } else {
            this.zip(rootDir, this.listLogFiles(rootDir), out);
        }
    }

    public LogDesc getPythonScriptLogContent(String string) throws IOException {
        int defaultNumberOfLines = 1000;
        return this.getLogContent(pythonScriptsLogFolder, string, defaultNumberOfLines);
    }

    public LogDesc getLogContent(String string) throws IOException {
        int defaultNumberOfLines = 1000;
        return this.getLogContent(logsFolder, string, defaultNumberOfLines);
    }

    private LogDesc getLogContent(File rootDir, String logName, int lines) throws IOException {
        String canonicalLogDir;
        File logFile = DKUFileUtils.getWithin((File)rootDir, (String[])new String[]{logName});
        String canonicalFile = logFile.getCanonicalPath();
        if (!canonicalFile.startsWith(canonicalLogDir = rootDir.getCanonicalPath())) {
            throw new SecurityException("Trying to read outside of logs dir");
        }
        return this.tail(rootDir, logFile, lines);
    }

    private List<Path> listLogFiles(File startingDir) {
        ArrayList<Path> logFiles = new ArrayList<Path>();
        try {
            EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            Files.walkFileTree(startingDir.toPath(), opts, 5, new LogFilesVisitor(logFiles));
        }
        catch (IOException e) {
            logger.warn((Object)"Listing log files failed", (Throwable)e);
        }
        return logFiles;
    }

    public List<LogDesc> listPythonScriptsLogs() {
        return this.listLogs(pythonScriptsLogFolder);
    }

    public List<LogDesc> listLogs() {
        return this.listLogs(logsFolder);
    }

    private List<LogDesc> listLogs(File startingDir) {
        List<Path> logPaths = this.listLogFiles(startingDir);
        ArrayList logDescs = Lists.newArrayList();
        for (Path logPath : logPaths) {
            try {
                LogDesc log = new LogDesc(logPath.toFile(), startingDir);
                logDescs.add(log);
            }
            catch (Exception e) {
                logger.warn((Object)"Listing log files failed", (Throwable)e);
            }
        }
        return logDescs;
    }

    LogDesc tail(File rootDir, File file, int lines) throws IOException {
        LogDesc log = new LogDesc(file, rootDir);
        log.linesShown = lines;
        log.tail = LogsService.getSmartLogTail(DKUtils.tailFile((File)file, (int)lines), null);
        return log;
    }

    void zip(File rootDir, Iterable<Path> paths, OutputStream out) throws IOException {
        logger.info((Object)"Start compressed stream");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(out);){
            for (Path path : paths) {
                logger.info((Object)("Adding " + path.toString()));
                File file = path.toFile();
                LogDesc desc = new LogDesc(file, rootDir);
                ZipArchiveEntry ae = zos.createArchiveEntry(file, desc.name);
                zos.putArchiveEntry(ae);
                try (FileInputStream is = new FileInputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                }
                zos.closeArchiveEntry();
            }
        }
    }

    void zip(File file, OutputStream out) throws IOException {
        logger.info((Object)"Start compressed stream");
        try (GZIPOutputStream zos = new GZIPOutputStream(out);
             FileInputStream is = new FileInputStream(file);){
            IOUtils.copy((InputStream)is, (OutputStream)zos);
        }
    }

    private static SmartLogTail getSmartLogTail(String tail, String activityId) {
        String[] lines;
        SmartLogTail ret = new SmartLogTail();
        for (String line : lines = tail.split("\n")) {
            if (activityId != null) {
                line = line.replace("starting " + activityId + " ", "");
                line = line.replace("act." + activityId + " ", "");
            }
            ret.appendLine(line);
        }
        return ret;
    }

    @UIModel
    public static class LogDesc {
        public String name;
        long totalSize;
        long lastModified;
        SmartLogTail tail;
        long linesShown;
        long tailSize;
        boolean truncated = true;

        public LogDesc(File file) {
            this.name = logsFolder.toURI().relativize(file.toURI()).getPath();
            this.totalSize = file.length();
            this.lastModified = file.lastModified();
        }

        public LogDesc(File file, File folder) {
            this.name = folder.toURI().relativize(file.toURI()).getPath();
            this.totalSize = file.length();
            this.lastModified = file.lastModified();
        }

        public String toString() {
            return this.name + "(size:" + this.totalSize + ", lastModified:" + this.lastModified + ")";
        }
    }

    public static class LogFilesVisitor
    extends SimpleFileVisitor<Path> {
        List<Path> logFiles;

        public LogFilesVisitor(List<Path> logFiles) {
            this.logFiles = logFiles;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attr) {
            String fileName = path.toFile().getName();
            if (attr.isRegularFile() && fileName.contains(".log") && !fileName.endsWith(".lck")) {
                this.logFiles.add(path);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

