/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.admin;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.security.ldap.LdapSettings;
import com.dataiku.dip.security.sso.DSSSSOService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIIAMController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private DSSSSOService dssssoService;

    @RequestMapping(value={"/publicapi/admin/iam/sso-settings"}, method={RequestMethod.GET})
    public void getSSOSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        SSOSettings ssoSettings;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            ssoSettings = this.generalSettingsService.read().ssoSettings;
        }
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)ssoSettings);
    }

    @RequestMapping(value={"/publicapi/admin/iam/sso-settings"}, method={RequestMethod.PUT})
    public void updateSSOSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        SSOSettings ssoSettings = (SSOSettings)this.getRequestBodyAs(req, SSOSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsService.read();
            generalSettings.ssoSettings = ssoSettings;
            this.generalSettingsService.save(authCtx, generalSettings);
            t.commit("Save SSO settings");
        }
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)ssoSettings);
    }

    @RequestMapping(value={"/publicapi/admin/iam/ldap-settings"}, method={RequestMethod.GET})
    public void getLDAPSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        LdapSettings ldapSettings;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            ldapSettings = this.generalSettingsService.read().ldapSettings;
        }
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)ldapSettings);
    }

    @RequestMapping(value={"/publicapi/admin/iam/ldap-settings"}, method={RequestMethod.PUT})
    public void updateLDAPSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        LdapSettings ldapSettings = (LdapSettings)this.getRequestBodyAs(req, LdapSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsService.read();
            generalSettings.ldapSettings = ldapSettings;
            this.generalSettingsService.save(authCtx, generalSettings);
            t.commit("Save LDAP settings");
        }
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)ldapSettings);
    }

    @RequestMapping(value={"/publicapi/admin/iam/azure-ad-settings"}, method={RequestMethod.GET})
    public void getAzureADSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AzureADSettings azureADSettings;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            azureADSettings = this.generalSettingsService.read().azureADSettings;
        }
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)azureADSettings);
    }

    @RequestMapping(value={"/publicapi/admin/iam/azure-ad-settings"}, method={RequestMethod.PUT})
    public void updateAzureADSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        AzureADSettings azureADSettings = (AzureADSettings)this.getRequestBodyAs(req, AzureADSettings.class);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsService.read();
            generalSettings.azureADSettings = azureADSettings;
            this.generalSettingsService.save(authCtx, generalSettings);
            t.commit("Save Azure AD settings");
        }
        PublicAPIIAMController.writeJSON((HttpServletResponse)resp, (Object)azureADSettings);
    }
}

