/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.pages;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.catalog.AbstractIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.AbstractSearchService;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.LuceneSecureIndexReader;
import com.dataiku.dip.server.services.catalog.PageSettingsCatalogService;
import com.dataiku.dip.server.services.catalog.pages.PagesSettingsCatalogPermissionService;
import com.dataiku.dip.server.services.catalog.pages.PagesSettingsIndexingQueueHandler;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetResult;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetsCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetsCollectorManager;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.LabelAndValue;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.ParseException;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.QueryParser;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Collector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MultiCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopScoreDocCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopScoreDocCollectorManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PagesSettingsCatalogService
extends AbstractSearchService
implements PageSettingsCatalogService {
    @Autowired
    private PagesSettingsIndexingQueueHandler queueHandler;
    @Autowired
    private PagesSettingsCatalogPermissionService pagesSettingsCatalogPermissionService;
    @Autowired
    @Qualifier(value="pageMappingsAnalyzer")
    private LuceneMappingsAnalyzer pageLuceneMappingsAnalyzer;
    @Autowired
    @Qualifier(value="pageIndexManager")
    private LuceneIndexManager pageIndexManager;
    protected static final DKULogger logger = DKULogger.getLogger((String)PagesSettingsCatalogService.class.getSimpleName());
    public static final String TYPE = IndexableType.PAGE.index();
    private static final int MAX_NB_SCOPE = 1000;

    @Override
    public AbstractIndexingQueueHandler getQueueHandler() {
        return this.queueHandler;
    }

    @Override
    public void subscribeEvents() {
        this.pubSub.subscribe("page-settings-force-index-all", (DSSEventListener)this);
    }

    @Override
    protected Query accessFilter(AuthCtx user) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneResponseWrapper search(String queryString, Map<String, List<String>> inputFacets, AuthCtx user, boolean retryEscaped, PageSettingsCatalogService.Options options) throws IOException, ParseException, DKUSecurityException {
        Query q;
        LuceneResponseWrapper result = new LuceneResponseWrapper();
        TopScoreDocCollector topDocsCollector = new TopScoreDocCollectorManager(options.getMaxSize(), options.getMaxSize()).newCollector();
        FacetsCollector facetsCollector = new FacetsCollectorManager().newCollector();
        BooleanQuery.Builder rootBooleanQueryBuilder = new BooleanQuery.Builder();
        if (inputFacets != null && inputFacets.containsKey("scope") && !inputFacets.get("scope").isEmpty()) {
            BooleanQuery.Builder boolQueryBuilder = new BooleanQuery.Builder();
            for (String value : inputFacets.get("scope")) {
                boolQueryBuilder.add((Query)new TermQuery(new Term("scope", value.toLowerCase())), BooleanClause.Occur.SHOULD);
            }
            BooleanQuery intermediateFilterQuery = boolQueryBuilder.build();
            rootBooleanQueryBuilder.add((Query)new BooleanQuery.Builder().add((Query)intermediateFilterQuery, BooleanClause.Occur.MUST).build(), BooleanClause.Occur.FILTER);
        }
        rootBooleanQueryBuilder.add(PagesSettingsCatalogService.getSecurityQuery(this.pagesSettingsCatalogPermissionService.getPermissionParams((DSSAuthCtx)user, options.getProjectKey())), BooleanClause.Occur.FILTER);
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("name", Float.valueOf(3.0f));
        boosts.put("path", Float.valueOf(1.0f));
        try {
            q = this.buildStringQuery(queryString, boosts, this.pageLuceneMappingsAnalyzer.getPerFieldAnalyzerWrapper(TYPE), this.pageLuceneMappingsAnalyzer.getMappingForType(TYPE));
        }
        catch (ParseException e) {
            if (retryEscaped && !AbstractSearchService.isEscapedQueryString(queryString)) {
                queryString = QueryParser.escape((String)queryString);
                return this.search(queryString, inputFacets, user, false, options);
            }
            throw e;
        }
        rootBooleanQueryBuilder.add(q, BooleanClause.Occur.MUST);
        BooleanQuery rootQuery = rootBooleanQueryBuilder.build();
        FacetResult facetResult = null;
        IndexSearcher indexSearcher = this.pageIndexManager.acquireIndexSearcher();
        try {
            LuceneSecureIndexReader secureIndexReader = this.pageIndexManager.getSecureIndexReader(indexSearcher);
            try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"pages-settings.search.request");){
                indexSearcher.search((Query)rootQuery, MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, facetsCollector}));
                this.addHitsInResponse(secureIndexReader, IndexableType.forName((String)TYPE), topDocsCollector.topDocs(), result, this.pageIndexManager);
                if (options.needsAggregation() && !secureIndexReader.isIndexEmpty()) {
                    DefaultSortedSetDocValuesReaderState state = new DefaultSortedSetDocValuesReaderState(secureIndexReader.getIndexReader(), "facet_scope", this.pageLuceneMappingsAnalyzer.getFacetsConfig());
                    SortedSetDocValuesFacetCounts facets = new SortedSetDocValuesFacetCounts((SortedSetDocValuesReaderState)state, facetsCollector);
                    facetResult = facets.getTopChildren(1000, "facet_scope", new String[0]);
                }
            }
        }
        finally {
            this.pageIndexManager.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        if (facetResult != null) {
            ArrayList<LabelAndValue> labelAndValueList = new ArrayList<LabelAndValue>(Arrays.asList(facetResult.labelValues));
            LuceneResponseWrapper.Aggregation aggregation = new LuceneResponseWrapper.Aggregation(labelAndValueList, (long)facetResult.value.intValue());
            result.aggregations.put("navigation", aggregation);
        }
        if (result.totalHits.value == 0L && retryEscaped && !AbstractSearchService.isEscapedQueryString(queryString)) {
            queryString = QueryParser.escape((String)queryString);
            return this.search(queryString, inputFacets, user, false, options);
        }
        result.serializeJsonPayloads(this.pageLuceneMappingsAnalyzer.getJsons(TYPE));
        return result;
    }

    private static Query getSecurityQuery(Map<String, Boolean> permissionParams) {
        BooleanQuery.Builder securityBooleanQueryBuilder = new BooleanQuery.Builder();
        Set<String> permissions = permissionParams.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        securityBooleanQueryBuilder.add((Query)new TermQuery(new Term("permission", "__DKU__NULL__VALUE__")), BooleanClause.Occur.SHOULD);
        permissions.forEach(p -> securityBooleanQueryBuilder.add((Query)new TermQuery(new Term("permission", p)), BooleanClause.Occur.SHOULD));
        return securityBooleanQueryBuilder.build();
    }
}

