/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.waiters;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetHealthResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.waiters.DescribeLoadBalancersFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.waiters.DescribeTargetHealthFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.waiters.LoadBalancerAvailable;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.waiters.LoadBalancerExists;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.waiters.LoadBalancersDeleted;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.waiters.TargetDeregistered;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.waiters.TargetInService;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.FixedDelayStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.PollingStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.Waiter;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterBuilder;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterExecutorServiceFactory;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;

public class AmazonElasticLoadBalancingWaiters {
    private final AmazonElasticLoadBalancing client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonElasticLoadBalancingWaiters");

    @SdkInternalApi
    public AmazonElasticLoadBalancingWaiters(AmazonElasticLoadBalancing client) {
        this.client = client;
    }

    public Waiter<DescribeLoadBalancersRequest> loadBalancerAvailable() {
        return new WaiterBuilder<DescribeLoadBalancersRequest, DescribeLoadBalancersResult>().withSdkFunction(new DescribeLoadBalancersFunction(this.client)).withAcceptors(new LoadBalancerAvailable.IsActiveMatcher(), new LoadBalancerAvailable.IsProvisioningMatcher(), new LoadBalancerAvailable.IsLoadBalancerNotFoundMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTargetHealthRequest> targetDeregistered() {
        return new WaiterBuilder<DescribeTargetHealthRequest, DescribeTargetHealthResult>().withSdkFunction(new DescribeTargetHealthFunction(this.client)).withAcceptors(new TargetDeregistered.IsInvalidTargetMatcher(), new TargetDeregistered.IsUnusedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTargetHealthRequest> targetInService() {
        return new WaiterBuilder<DescribeTargetHealthRequest, DescribeTargetHealthResult>().withSdkFunction(new DescribeTargetHealthFunction(this.client)).withAcceptors(new TargetInService.IsHealthyMatcher(), new TargetInService.IsInvalidInstanceMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeLoadBalancersRequest> loadBalancerExists() {
        return new WaiterBuilder<DescribeLoadBalancersRequest, DescribeLoadBalancersResult>().withSdkFunction(new DescribeLoadBalancersFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new LoadBalancerExists.IsLoadBalancerNotFoundMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeLoadBalancersRequest> loadBalancersDeleted() {
        return new WaiterBuilder<DescribeLoadBalancersRequest, DescribeLoadBalancersResult>().withSdkFunction(new DescribeLoadBalancersFunction(this.client)).withAcceptors(new LoadBalancersDeleted.IsActiveMatcher(), new LoadBalancersDeleted.IsLoadBalancerNotFoundMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

