/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.server;

import com.dataiku.common.server.WarningEmitterBigPayload;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;

public class CountingServletOutputStream
extends ServletOutputStream {
    private final ServletOutputStream original;
    private final WarningEmitterBigPayload warningEmitter;

    public CountingServletOutputStream(ServletOutputStream original, int byteCount) {
        this.original = original;
        this.warningEmitter = new WarningEmitterBigPayload();
    }

    public CountingServletOutputStream(ServletOutputStream original) {
        this(original, 0);
    }

    public void write(int b) throws IOException {
        this.warningEmitter.incrementByteCount(1);
        this.original.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.warningEmitter.incrementByteCount(len);
        this.original.write(b, off, len);
    }

    public boolean isReady() {
        return this.original.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.original.setWriteListener(writeListener);
    }

    public void flush() throws IOException {
        this.original.flush();
    }

    public void close() throws IOException {
        this.original.close();
    }

    public long getByteCount() {
        return this.warningEmitter.getByteCount();
    }
}

