/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.licensing;

import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.server.services.UsageDataReporting;
import com.dataiku.dip.utils.Params;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractLicenseFeaturesStatusBuilder {
    protected AbstractLicenseFeaturesStatusBuilder() {
    }

    protected abstract void allowAllDatasets(LicenseFeaturesStatus var1);

    protected Set<String> connectionType(String datasetType) {
        switch (datasetType) {
            case "S3": {
                return Sets.newHashSet((Object[])new String[]{"EC2"});
            }
            case "SCP": {
                return Sets.newHashSet((Object[])new String[]{"SSH"});
            }
            case "SFTP": {
                return Sets.newHashSet((Object[])new String[]{"SSH"});
            }
        }
        return Sets.newHashSet((Object[])new String[]{datasetType});
    }

    private void forbidDatasetTypes(LicenseFeaturesStatus ret, String ... types) {
        for (String type : types) {
            String trim = type.trim();
            ret.allowedDatasetTypes.remove(trim);
            ret.allowedConnectionTypes.removeAll(this.connectionType(trim));
        }
    }

    private void allowDatasetTypes(LicenseFeaturesStatus ret, String ... types) {
        for (String type : types) {
            String trim = type.trim();
            ret.allowedDatasetTypes.add(trim);
            ret.allowedConnectionTypes.addAll(this.connectionType(trim));
        }
    }

    private void allowDiscoverAutomation(LicenseFeaturesStatus ret) {
        ret.bundlesAllowed = false;
        ret.advancedScenarioStepsAllowed = true;
        ret.temporalTriggerAllowed = true;
        ret.allScenarioTriggersAllowed = false;
        ret.allScenarioReportersAllowed = true;
        ret.advancedMetricsChecksAllowed = true;
    }

    private void allowFullAutomation(LicenseFeaturesStatus ret) {
        ret.bundlesAllowed = true;
        ret.advancedScenarioStepsAllowed = true;
        ret.temporalTriggerAllowed = true;
        ret.allScenarioTriggersAllowed = true;
        ret.allScenarioReportersAllowed = true;
        ret.advancedMetricsChecksAllowed = true;
    }

    private void setModelExportAllowed(LicenseFeaturesStatus ret, boolean allowed) {
        ret.modelsExport = allowed;
    }

    protected LicenseFeaturesStatus buildFeaturesStatus(LicenseStatusService.LicensingStatus ls) {
        String reportingMode;
        LicenseFeaturesStatus ret = new LicenseFeaturesStatus();
        Params params = new Params();
        if (ls.hasLicense && ls.licenseContent.properties != null) {
            params = new Params(ls.licenseContent.properties);
        }
        String standardOffer = params.getParam("standardOffer", null);
        if (ls.ceEntrepriseTrial) {
            ret.limitedEditionString = "Free Edition (with advanced features trial)";
        } else if (ls.community) {
            ret.limitedEditionString = "Free Edition";
        } else if ("lite".equals(params.getParam("licenseLimitsVersion", null))) {
            ret.limitedEditionString = "Lite Edition";
        }
        if (standardOffer != null) {
            ret.ldapAllowed = true;
            ret.userSecurityAllowed = true;
            ret.sparkAllowed = true;
            ret.sparkMLLibAllowed = true;
            switch (standardOffer) {
                case "custom-discover-2021": {
                    this.allowAllDatasets(ret);
                    this.forbidDatasetTypes(ret, "Teradata", "SAPHANA", "Netezza");
                    ret.ssoAllowed = false;
                    ret.multiUserSecurityAllowed = false;
                    ret.apiNodeAllowed = false;
                    this.allowDiscoverAutomation(ret);
                    this.setModelExportAllowed(ret, false);
                    break;
                }
                case "cloudstacks-discover-2021": {
                    this.allowAllDatasets(ret);
                    this.forbidDatasetTypes(ret, "Teradata", "SAPHANA", "Netezza");
                    ret.ssoAllowed = false;
                    ret.multiUserSecurityAllowed = false;
                    ret.apiNodeAllowed = true;
                    ret.deployerMaxAPIDeployments = 1;
                    this.allowDiscoverAutomation(ret);
                    this.setModelExportAllowed(ret, false);
                    break;
                }
                case "online-discover-fy2023-1": {
                    this.allowAllDatasets(ret);
                    this.forbidDatasetTypes(ret, "Teradata", "SAPHANA", "Netezza");
                    ret.ssoAllowed = true;
                    ret.multiUserSecurityAllowed = false;
                    ret.apiNodeAllowed = true;
                    ret.deployerMaxAPIDeployments = 1;
                    this.allowDiscoverAutomation(ret);
                    this.setModelExportAllowed(ret, false);
                    break;
                }
                case "discover-fy2023-1": 
                case "cloustacks-discover-fy2023-1": {
                    this.allowAllDatasets(ret);
                    this.forbidDatasetTypes(ret, "Teradata", "SAPHANA", "Netezza");
                    ret.ssoAllowed = false;
                    ret.multiUserSecurityAllowed = false;
                    ret.apiNodeAllowed = false;
                    this.allowDiscoverAutomation(ret);
                    this.setModelExportAllowed(ret, false);
                    break;
                }
                case "online-business-fy2023-1": {
                    this.allowAllDatasets(ret);
                    this.forbidDatasetTypes(ret, "Teradata", "SAPHANA", "Netezza");
                    ret.ssoAllowed = true;
                    ret.multiUserSecurityAllowed = false;
                    ret.apiNodeAllowed = true;
                    ret.deployerMaxAPIDeployments = 5;
                    this.allowFullAutomation(ret);
                    this.setModelExportAllowed(ret, false);
                    break;
                }
                case "custom-business-2021": 
                case "cloudstacks-business-2021": 
                case "business-fy2023-1": 
                case "cloudstacks-business-fy2023-1": {
                    this.allowAllDatasets(ret);
                    this.forbidDatasetTypes(ret, "Teradata", "SAPHANA", "Netezza");
                    ret.ssoAllowed = false;
                    ret.multiUserSecurityAllowed = false;
                    ret.apiNodeAllowed = true;
                    ret.deployerMaxAPIDeployments = 5;
                    this.allowFullAutomation(ret);
                    this.setModelExportAllowed(ret, false);
                    break;
                }
                case "custom-enterprise-2021": 
                case "cloudstacks-enterprise-2021": 
                case "enterprise-fy2023-1": 
                case "cloudstacks-enterprise-fy2023-1": {
                    this.allowAllDatasets(ret);
                    ret.ssoAllowed = true;
                    ret.multiUserSecurityAllowed = true;
                    ret.apiNodeAllowed = true;
                    ret.projectStandardsAllowed = true;
                    this.allowFullAutomation(ret);
                    this.setModelExportAllowed(ret, true);
                    ret.governAllowed = true;
                    ret.enterpriseAssetLibraryMaxNumCollections = -1;
                    ret.enterpriseProjectsAllowed = true;
                    ret.businessAppsAllowed = true;
                    break;
                }
                case "data-analytics-foundation-fy2025-1": 
                case "data-analytics-fy2025-1": {
                    this.allowAllDatasets(ret);
                    this.forbidDatasetTypes(ret, "Teradata", "SAPHANA");
                    ret.multiUserSecurityAllowed = true;
                    ret.ssoAllowed = false;
                    ret.apiNodeAllowed = false;
                    this.allowFullAutomation(ret);
                    this.setModelExportAllowed(ret, false);
                    ret.governAllowed = false;
                    break;
                }
                case "ai-ml-fy2025-1": 
                case "ai-ml-foundation-fy2025-1": {
                    this.allowAllDatasets(ret);
                    this.forbidDatasetTypes(ret, "Teradata", "SAPHANA");
                    ret.multiUserSecurityAllowed = true;
                    ret.ssoAllowed = false;
                    ret.apiNodeAllowed = true;
                    this.allowFullAutomation(ret);
                    this.setModelExportAllowed(ret, true);
                    ret.governAllowed = false;
                    break;
                }
                case "enterprise-ai-fy2025-1": {
                    this.allowAllDatasets(ret);
                    ret.ssoAllowed = true;
                    ret.multiUserSecurityAllowed = true;
                    ret.apiNodeAllowed = true;
                    ret.projectStandardsAllowed = true;
                    this.allowFullAutomation(ret);
                    this.setModelExportAllowed(ret, true);
                    ret.governAllowed = true;
                    ret.enterpriseAssetLibraryMaxNumCollections = -1;
                    ret.enterpriseProjectsAllowed = true;
                    ret.businessAppsAllowed = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized standard offer '" + standardOffer + "', you may need to upgrade this DSS");
                }
            }
            if (params.getBoolParam("addons.teradata", false)) {
                this.allowDatasetTypes(ret, "Teradata");
            }
            if (params.getBoolParam("addons.saphana", false)) {
                this.allowDatasetTypes(ret, "SAPHANA");
            }
            if (params.getBoolParam("addons.advancedLLMMesh", false)) {
                ret.advancedLLMMeshAllowed = true;
            }
            if (params.getBoolParam("addons.standardGovern", false)) {
                ret.governAllowed = true;
            }
            if (params.getBoolParam("addons.advancedGovern", false)) {
                ret.governAllowed = true;
                ret.governBlueprintDesignerAllowed = true;
            }
            if (params.getBoolParam("addons.stories", false)) {
                ret.storiesAllowed = true;
            }
            if (params.getBoolParam("addons.advancedAuthentication", false)) {
                ret.ssoAllowed = true;
            }
            ret.ssoAllowed = params.getBoolParam("features.security.sso", ret.ssoAllowed);
            ret.modelsRawSQLExport = params.getBoolParam("features.models.rawSQLExport", ret.modelsRawSQLExport);
            ret.modelsPMMLExport = params.getBoolParam("features.models.pmmlExport", ret.modelsPMMLExport);
            ret.modelsJarExport = params.getBoolParam("features.models.jarExport", ret.modelsJarExport);
            ret.modelsExport = params.getBoolParam("features.models.modelExport", ret.modelsExport);
            ret.modelsExport = ret.isModelExportAllowed();
            ret.apiNodeAllowed = params.getBoolParam("features.apinode", ret.apiNodeAllowed);
            String maxDeploymentsInLicense = params.getParam("limits.deployerMaxAPIDeployments");
            if (maxDeploymentsInLicense != null) {
                ret.deployerMaxAPIDeployments = Integer.parseInt(maxDeploymentsInLicense);
            }
            ret.governAllowed = params.getBoolParam("features.govern", ret.governAllowed);
            ret.governBlueprintDesignerAllowed = params.getBoolParam("features.govern.blueprintDesigner", ret.governBlueprintDesignerAllowed);
            ret.storiesAllowed = params.getBoolParam("features.stories", ret.storiesAllowed);
            ret.projectStandardsAllowed = params.getBoolParam("features.projectStandards", ret.projectStandardsAllowed);
        } else {
            String datasetTypes = params.getParam("allowedDatasetTypes");
            if (datasetTypes != null) {
                for (String type : datasetTypes.split(",")) {
                    String trim = type.trim();
                    ret.allowedDatasetTypes.add(trim);
                    ret.allowedConnectionTypes.addAll(this.connectionType(trim));
                }
            } else {
                this.allowAllDatasets(ret);
            }
            ret.allowedConnectionTypes.add("Filesystem");
            String forbiddenDatasetTypes = params.getParam("restrictions.forbiddenDatasetTypes");
            if (forbiddenDatasetTypes != null) {
                for (String type : forbiddenDatasetTypes.split(",")) {
                    String trim = type.trim();
                    ret.allowedDatasetTypes.remove(trim);
                    ret.allowedConnectionTypes.removeAll(this.connectionType(trim));
                }
            }
            ret.ldapAllowed = params.getBoolParam("features.security.ldap", false);
            ret.ssoAllowed = params.getBoolParam("features.security.sso", false);
            ret.multiUserSecurityAllowed = params.getBoolParam("features.security.multiUserSecurity", false);
            ret.sparkAllowed = params.getBoolParam("features.engines.spark", false);
            ret.sparkMLLibAllowed = params.getBoolParam("features.engines.sparkMLLib", false);
            ret.apiNodeAllowed = params.getBoolParam("features.apinode", false);
            ret.bundlesAllowed = params.getBoolParam("features.automationServer", false);
            ret.governAllowed = params.getBoolParam("features.govern", true);
            ret.governBlueprintDesignerAllowed = params.getBoolParam("features.govern.blueprintDesigner", false);
            ret.storiesAllowed = params.getBoolParam("features.stories", false);
            ret.projectStandardsAllowed = params.getBoolParam("features.projectStandards", false);
            boolean is2018AutomationFeatures = params.getParam("automationFeaturesVersion", "OLD").equals("2018-1");
            boolean isCustomAutomationFeatures = params.getParam("automationFeaturesVersion", "OLD").equals("custom");
            if (is2018AutomationFeatures) {
                if (params.getBoolParam("features.automation2018", false)) {
                    ret.advancedScenarioStepsAllowed = true;
                    ret.temporalTriggerAllowed = true;
                    ret.allScenarioTriggersAllowed = true;
                    ret.allScenarioReportersAllowed = true;
                    ret.advancedMetricsChecksAllowed = true;
                } else if (params.getBoolParam("features.liteEditionAutomation", false)) {
                    ret.advancedScenarioStepsAllowed = true;
                    ret.temporalTriggerAllowed = true;
                    ret.allScenarioTriggersAllowed = false;
                    ret.allScenarioReportersAllowed = true;
                    ret.advancedMetricsChecksAllowed = true;
                } else {
                    ret.advancedScenarioStepsAllowed = true;
                    ret.temporalTriggerAllowed = false;
                    ret.allScenarioTriggersAllowed = false;
                    ret.allScenarioReportersAllowed = false;
                    ret.advancedMetricsChecksAllowed = false;
                }
            } else if (isCustomAutomationFeatures) {
                ret.advancedScenarioStepsAllowed = params.getBoolParam("features.automation.advancedScenarioSteps", false);
                ret.temporalTriggerAllowed = params.getBoolParam("features.automation.temporalTrigger", false);
                ret.allScenarioTriggersAllowed = params.getBoolParam("features.automation.advancedTriggers", false);
                ret.allScenarioReportersAllowed = params.getBoolParam("features.automation.reporters", false);
                ret.advancedMetricsChecksAllowed = params.getBoolParam("features.automation.metricsChecks", false);
            } else if (params.getBoolParam("features.advancedScenarios", false)) {
                ret.advancedScenarioStepsAllowed = true;
                ret.temporalTriggerAllowed = true;
                ret.allScenarioTriggersAllowed = true;
                ret.allScenarioReportersAllowed = true;
                ret.advancedMetricsChecksAllowed = true;
            } else {
                ret.advancedScenarioStepsAllowed = false;
                ret.temporalTriggerAllowed = true;
                ret.allScenarioTriggersAllowed = false;
                ret.allScenarioReportersAllowed = true;
                ret.advancedMetricsChecksAllowed = false;
            }
            if (ls.ceEntrepriseTrial) {
                ret.advancedScenarioStepsAllowed = true;
                ret.temporalTriggerAllowed = true;
                ret.allScenarioTriggersAllowed = true;
                ret.allScenarioReportersAllowed = true;
                ret.advancedMetricsChecksAllowed = true;
            }
            ret.userSecurityAllowed = !ls.community && !ls.ceEntrepriseTrial && !params.getBoolParam("restrictions.globalPermissions", false);
            ret.modelsRawSQLExport = params.getBoolParam("features.models.rawSQLExport", false);
            ret.modelsPMMLExport = params.getBoolParam("features.models.pmmlExport", false);
            ret.modelsJarExport = params.getBoolParam("features.models.jarExport", false);
            ret.modelsExport = params.getBoolParam("features.models.modelExport", false);
            ret.modelsExport = ret.isModelExportAllowed();
            ret.advancedLLMMeshAllowed = params.getBoolParam("features.advancedLLMMesh", false);
        }
        ret.allowedConnectionTypes.add("OpenAI");
        ret.allowedConnectionTypes.add("AzureOpenAI");
        ret.allowedConnectionTypes.add("AzureAIFoundry");
        ret.allowedConnectionTypes.add("Cohere");
        ret.allowedConnectionTypes.add("MistralAI");
        ret.allowedConnectionTypes.add("Anthropic");
        ret.allowedConnectionTypes.add("Bedrock");
        ret.allowedConnectionTypes.add("MosaicML");
        ret.allowedConnectionTypes.add("VertexAILLM");
        ret.allowedConnectionTypes.add("DatabricksLLM");
        ret.allowedConnectionTypes.add("SnowflakeCortex");
        ret.allowedConnectionTypes.add("StabilityAI");
        ret.allowedConnectionTypes.add("HuggingFaceLocal");
        ret.allowedConnectionTypes.add("HuggingFaceInferenceAPI");
        ret.allowedConnectionTypes.add("CustomLLM");
        ret.allowedConnectionTypes.add("Pinecone");
        ret.allowedConnectionTypes.add("SageMaker-GenericLLM");
        ret.allowedConnectionTypes.add("AzureLLM");
        ret.allowedConnectionTypes.add("AzureAISearch");
        ret.allowedConnectionTypes.add("NVIDIA-NIM");
        ret.allowedConnectionTypes.add("RemoteMCP");
        ret.allowedConnectionTypes.add("SageMaker");
        ret.allowedConnectionTypes.add("AzureML");
        ret.allowedConnectionTypes.add("VertexAIModelDeployment");
        ret.allowedConnectionTypes.add("DatabricksModelDeployment");
        ret.allowedConnectionTypes.add("SharePointOnline");
        String privacyMode = params.getParam("usageData.privacyMode", null);
        if (privacyMode != null) {
            ret.udrPrivacyMode = UsageDataReporting.UsageDataReportingPrivacyMode.valueOf(privacyMode);
        }
        if ("DEFAULT".equals(reportingMode = params.getParam("usageData.reportingMode"))) {
            ret.mandatoryMinimalTracking = true;
        }
        ret.lockedTracking = params.getBoolParam("restrictions.lockedTracking", false);
        ret.forbiddenTracking = params.getBoolParam("restrictions.forbiddenTracking", false);
        if (params.getBoolParam("restrictions.mandatoryMinimalReporting", false)) {
            ret.mandatoryMinimalTracking = true;
        }
        return ret;
    }

    @UIModel
    public static class LicenseFeaturesStatus {
        public String limitedEditionString;
        Set<String> allowedDatasetTypes = new HashSet<String>();
        Set<String> allowedConnectionTypes = new HashSet<String>();
        public boolean ldapAllowed;
        public boolean ssoAllowed;
        public boolean userSecurityAllowed;
        public boolean multiUserSecurityAllowed;
        public boolean sparkAllowed;
        public boolean sparkMLLibAllowed;
        public boolean apiNodeAllowed;
        public Integer deployerMaxAPIDeployments;
        public boolean bundlesAllowed;
        public boolean advancedScenarioStepsAllowed;
        public boolean temporalTriggerAllowed;
        public boolean allScenarioTriggersAllowed;
        public boolean allScenarioReportersAllowed;
        public boolean advancedMetricsChecksAllowed;
        public boolean modelsRawSQLExport;
        public boolean modelsPMMLExport;
        public boolean modelsJarExport;
        public boolean modelsExport;
        public boolean advancedLLMMeshAllowed;
        public boolean lockedTracking;
        public boolean mandatoryMinimalTracking;
        public boolean forbiddenTracking;
        public UsageDataReporting.UsageDataReportingPrivacyMode udrPrivacyMode;
        public boolean governAllowed;
        public boolean governBlueprintDesignerAllowed;
        public boolean storiesAllowed;
        public boolean projectStandardsAllowed;
        public Integer enterpriseAssetLibraryMaxNumCollections = 1;
        public boolean enterpriseProjectsAllowed;
        public boolean businessAppsAllowed;

        public boolean isModelExportAllowed() {
            return this.modelsExport || this.modelsRawSQLExport || this.modelsPMMLExport || this.modelsJarExport;
        }
    }

    public static class LicenseFeatureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LicenseFeatureException(String message) {
            super(message);
        }
    }
}

