/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.services;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.TestFlag;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceGenTag;
import com.dataiku.lambda.model.serverconfig.ServiceState;
import com.dataiku.lambda.services.ServiceManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeMultimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicesService {
    @Autowired
    private LambdaContext context;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    private Map<String, ServiceManager> serviceManagers = new HashMap<String, ServiceManager>();
    @VisibleForTesting
    public static final TestFlag skipInit = new TestFlag();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.dispatcher");

    @PostConstruct
    public void init() throws Exception {
        if (skipInit.isActivated()) {
            return;
        }
        logger.info((Object)"Registering and mounting Lambda services");
        File servicesDir = this.context.getFile(new String[]{"services"});
        if (!servicesDir.isDirectory()) {
            throw new IllegalStateException("Services directory does not exist: " + String.valueOf(servicesDir));
        }
        for (File serviceDir : servicesDir.listFiles()) {
            if (!serviceDir.isDirectory()) continue;
            String serviceId = serviceDir.getName();
            this.registerService(serviceId);
            this.loadFromPersistentState(serviceId);
        }
    }

    public synchronized ServiceManager getUniqueServiceManagerCheckExistence() {
        if (this.serviceManagers.size() != 1) {
            throw ErrorContext.iae((String)"Not only one service defined");
        }
        return this.serviceManagers.values().iterator().next();
    }

    public synchronized ServiceManager getServiceManager(String serviceId) {
        return this.serviceManagers.get(serviceId);
    }

    public synchronized ServiceManager getServiceManagerCheckExistence(String serviceId) {
        ServiceManager sm = this.serviceManagers.get(serviceId);
        if (sm == null) {
            throw ErrorContext.iaef((String)"Service %s does not exist", (Object)serviceId, (Object[])new Object[0]);
        }
        return sm;
    }

    public synchronized ServiceManager getServiceManagerCheck(String serviceId) {
        ServiceManager sm = this.serviceManagers.get(serviceId);
        if (sm == null) {
            throw ErrorContext.iaef((String)"Service %s does not exist", (Object)serviceId, (Object[])new Object[0]);
        }
        sm.checkActive();
        return sm;
    }

    public void createService(String id) throws IOException {
        File serviceDir = this.context.getFile(new String[]{"services", id});
        if (serviceDir.exists()) {
            throw new IllegalArgumentException("Service already exists: " + id);
        }
        DKUFileUtils.mkdirs((File)serviceDir);
        ServiceState state = this.readState(id);
        state.enabled = false;
        this.writeState(id, state);
        this.registerService(id);
    }

    public void destroyService(String id) throws IOException {
        try {
            for (LambdaServiceGenTag.WithStatus gen : this.getGenerations(id)) {
                this.destroyGeneration(id, gen.generationId);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not destroy service generations, continuing anyway", (Throwable)e);
        }
        try {
            this.unregisterService(id);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Could not unregister the service, continuing anyway", (Throwable)e);
        }
        File serviceDir = this.context.getFile(new String[]{"services", id});
        if (!serviceDir.exists()) {
            throw new IllegalArgumentException("Service directory does not exist: " + id);
        }
        DKUFileUtils.forceDelete((File)serviceDir);
    }

    public List<LambdaServiceGenTag.WithStatus> getGenerations(String serviceId) throws IOException {
        ServiceManager sm = this.serviceManagers.get(serviceId);
        Validate.notNull((Object)sm, (String)("Service does not exist: " + serviceId));
        File generationsDir = this.context.getFile(new String[]{"services", serviceId, "gens"});
        if (!generationsDir.isDirectory()) {
            return Lists.newLinkedList();
        }
        File[] genDirs = generationsDir.listFiles((FileFilter)DKUFileUtils.FileFilter.DIRECTORIES);
        ArrayList<LambdaServiceGenTag.WithStatus> gens = new ArrayList<LambdaServiceGenTag.WithStatus>(genDirs.length);
        for (File genDir : genDirs) {
            File tagFile = new File(genDir, "tag.json");
            if (!tagFile.isFile() || !tagFile.canRead()) continue;
            LambdaServiceGenTag.WithStatus gen = (LambdaServiceGenTag.WithStatus)JSON.parseFile((File)tagFile, LambdaServiceGenTag.WithStatus.class);
            gen.mounted = sm.isMounted(gen.generationId);
            if (sm.isActive()) {
                Double mapped = sm.getMapping(gen.generationId);
                gen.mapped = mapped == null ? 0.0 : mapped;
            }
            try {
                File configFile = new File(genDir, "config.json");
                if (configFile.isFile() && configFile.canRead()) {
                    LambdaServiceConfig config = (LambdaServiceConfig)JSON.parseFile((File)configFile, LambdaServiceConfig.class);
                    gen.deployerKeyHash = config.deployerKeyHash;
                }
            }
            catch (Exception e) {
                logger.warnV("Failed to read the configuration of the generation of service %s", new Object[]{serviceId});
            }
            gens.add(gen);
        }
        return gens;
    }

    public void destroyGeneration(String serviceId, String generationId) throws Exception {
        ServiceManager sm = this.serviceManagers.get(serviceId);
        Validate.notNull((Object)sm, (String)("Service does not exist: " + serviceId));
        sm.unloadAndUnmap(generationId);
        File generationDir = this.context.getFile(new String[]{"services", serviceId, "gens", generationId});
        if (generationDir.isDirectory()) {
            DKUFileUtils.deleteDirectory((File)generationDir);
        }
    }

    private void encryptApiKeysInGeneration(File generationDir) {
        File generationConfigFile = new File(generationDir, "config.json");
        if (generationConfigFile.exists()) {
            try {
                LambdaServiceConfig config = (LambdaServiceConfig)JSON.parseFile((File)generationConfigFile, LambdaServiceConfig.class);
                if (config.authRealm != null) {
                    config.authRealm.encryptKeysIfNotEncrypted(this.passwordEncryptionService);
                }
                JSON.prettyToFile((Object)config, (File)generationConfigFile);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Unable to encrypt generation %s API keys", new Object[]{generationDir.getName()});
            }
        } else {
            logger.warnV("Unable to find generation %s 'config.json' to encrypt API keys", new Object[]{generationDir.getName()});
        }
    }

    public String importGenerationFromArchive(String serviceId, File archive) throws ZipException, IOException {
        ServiceManager sm = this.serviceManagers.get(serviceId);
        Validate.notNull((Object)sm, (String)("Service does not exist: " + serviceId));
        Validate.isTrue((boolean)archive.exists(), (String)("Archive to import does not exist: " + String.valueOf(archive)));
        logger.infoV("Start to import to service %s from %s", new Object[]{serviceId, archive});
        String generationId = null;
        try (ZipFile zf = new ZipFile(archive);){
            ZipEntry tagEntry = zf.getEntry("tag.json");
            LambdaServiceGenTag tag = (LambdaServiceGenTag)JSON.parse((InputStream)zf.getInputStream(tagEntry), LambdaServiceGenTag.class);
            generationId = tag.generationId;
        }
        File generationsDir = this.context.getFile(new String[]{"services", serviceId, "gens"});
        File generationDir = new File(generationsDir, generationId);
        if (generationDir.exists()) {
            throw ErrorContext.iaef((String)"Target dir %s already exists", (Object)generationDir.getAbsolutePath(), (Object[])new Object[0]);
        }
        logger.infoV("Will use generation %s", new Object[]{generationDir.getName()});
        DKUFileUtils.mkdirs((File)generationDir);
        ZipUnzipDir.extractFolder((File)archive, (File)generationDir, (boolean)false);
        this.encryptApiKeysInGeneration(generationDir);
        return generationDir.getName();
    }

    public String importGenerationFromDir(String serviceId, File directory) throws ZipException, IOException {
        ServiceManager sm = this.serviceManagers.get(serviceId);
        Validate.notNull((Object)sm, (String)("Service does not exist: " + serviceId));
        Validate.isTrue((boolean)directory.isDirectory(), (String)("Directory to import does not exist: " + String.valueOf(directory)));
        Validate.isTrue((boolean)new File(directory, "tag.json").isFile(), (String)("Tag file does not exist in " + String.valueOf(directory)));
        logger.infoV("Start to import to service %s from %s", new Object[]{serviceId, directory});
        LambdaServiceGenTag tag = (LambdaServiceGenTag)JSON.parseFile((File)new File(directory, "tag.json"), LambdaServiceGenTag.class);
        File generationDir = this.context.getFile(new String[]{"services", serviceId, "gens", tag.generationId});
        logger.infoV("Importing to %s", new Object[]{generationDir});
        DKUFileUtils.mkdirs((File)generationDir);
        DKUFileUtils.copyDirectory((File)directory, (File)generationDir);
        this.encryptApiKeysInGeneration(generationDir);
        return generationDir.getName();
    }

    public String importGenerationFromStream(String serviceId, InputStream is) throws ZipException, IOException {
        ServiceManager sm = this.serviceManagers.get(serviceId);
        Validate.notNull((Object)sm, (String)("Service does not exist: " + serviceId));
        try (AutoDelete tmpDir = this.context.getTempFolder("api-node-package-import", serviceId + "-" + DKUDateUtils.isoFormatFileFriendlyLocalNow());){
            File tmpFile = new File((File)tmpDir, "archive.zip");
            FileUtils.copyInputStreamToFile((InputStream)is, (File)tmpFile);
            String string = this.importGenerationFromArchive(serviceId, tmpFile);
            return string;
        }
    }

    public void preloadGeneration(String serviceId, String generation, boolean forceRebuildCodeEnvs) throws Exception {
        ServiceManager sm = this.serviceManagers.get(serviceId);
        Validate.notNull((Object)sm);
        sm.mount(generation, forceRebuildCodeEnvs);
    }

    public void setMapping(String serviceId, GenerationsMapping mapping) throws Exception {
        logger.infoV("About to set mapping on service %s: %s", new Object[]{serviceId, JSON.log((Object)mapping)});
        mapping.validate();
        ServiceManager sm = this.serviceManagers.get(serviceId);
        Validate.notNull((Object)sm);
        sm.startAbortedReason = null;
        for (GenerationsMapping.MappingEntry me : mapping.getEntries()) {
            sm.mountIfNeeded(me.generation, false);
        }
        logger.infoV("All required generations mounted, persisting new mapping", new Object[0]);
        ServiceState state = this.readState(serviceId);
        state.enabled = true;
        state.activeMapping = mapping;
        this.writeState(serviceId, state);
        logger.infoV("Asking service %s to SWITCH to new mapping %s", new Object[]{serviceId, JSON.log((Object)mapping)});
        sm.setGenerationsMapping(mapping);
    }

    public String switchToNewestGeneration(String serviceId) throws Exception {
        Validate.notNull((Object)serviceId, (String)"No service ID given");
        this.getServiceManagerCheckExistence(serviceId);
        logger.infoV("Asking service %s to switch to NEWEST generation only", new Object[]{serviceId});
        String newestGen = this.getNewestGeneration(serviceId);
        this.switchToSingleGeneration(serviceId, newestGen);
        return newestGen;
    }

    public void switchToSingleGeneration(String serviceId, String generation) throws Exception {
        logger.infoV("Asking service %s to switch to SINGLE generation %s", new Object[]{serviceId, generation});
        GenerationsMapping previousActiveMapping = this.readState((String)serviceId).activeMapping;
        GenerationsMapping mapping = new GenerationsMapping();
        mapping.setSingleGeneration(generation);
        if (previousActiveMapping != null) {
            mapping.auditRoutingKey = previousActiveMapping.auditRoutingKey;
        }
        this.setMapping(serviceId, mapping);
    }

    public synchronized void disableServiceNoFail(String serviceId) throws IOException {
        logger.infoV("Disabling service %s", new Object[]{serviceId});
        ServiceState state = this.readState(serviceId);
        state.enabled = false;
        this.writeState(serviceId, state);
        ServiceManager sm = this.serviceManagers.get(serviceId);
        try {
            sm.shutdown();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to disable service, ignoring", (Throwable)e);
        }
    }

    public synchronized void disableService(String serviceId) throws Exception {
        logger.infoV("Disabling service %s", new Object[]{serviceId});
        this.getServiceManagerCheckExistence(serviceId);
        ServiceState state = this.readState(serviceId);
        if (!state.enabled) {
            throw ErrorContext.iaef((String)"Service %s is not enabled", (Object)serviceId, (Object[])new Object[0]);
        }
        state.enabled = false;
        this.writeState(serviceId, state);
        ServiceManager sm = this.serviceManagers.get(serviceId);
        sm.shutdown();
    }

    public synchronized void enableService(String serviceId) throws Exception {
        logger.infoV("Enabling service %s", new Object[]{serviceId});
        this.getServiceManagerCheckExistence(serviceId);
        ServiceState state = this.readState(serviceId);
        if (state.enabled) {
            throw ErrorContext.iaef((String)"Service %s is already enabled", (Object)serviceId, (Object[])new Object[0]);
        }
        if (state.activeMapping == null) {
            throw ErrorContext.iae((String)"Cannot enable a service without a generations mapping");
        }
        state.enabled = true;
        this.writeState(serviceId, state);
        this.setMapping(serviceId, state.activeMapping);
    }

    private String getNewestGeneration(String serviceId) throws IOException {
        File gensDir = this.context.getFile(new String[]{"services", serviceId, "gens"});
        Validate.isTrue((boolean)gensDir.isDirectory());
        long maxDate = -1L;
        String maxGen = null;
        for (File gen : gensDir.listFiles()) {
            File tagFile = new File(gen, "tag.json");
            if (!tagFile.exists()) continue;
            LambdaServiceGenTag tag = (LambdaServiceGenTag)JSON.parseFile((File)tagFile, LambdaServiceGenTag.class);
            if (tag.createdOn <= maxDate) continue;
            maxDate = tag.createdOn;
            maxGen = tag.generationId;
        }
        if (maxDate < 0L) {
            throw ErrorContext.iaef((String)"Found no available generation for service %s", (Object)serviceId, (Object[])new Object[0]);
        }
        return maxGen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServicesCleanupResponse cleanUnused() throws Exception {
        ServicesCleanupResponse res = new ServicesCleanupResponse();
        logger.info((Object)"Cleaning disabled services and unused generations...");
        List<ServiceSummaryState> serviceSummaryStates = this.listServices();
        ArrayList<String> servicesToScan = new ArrayList<String>();
        for (ServiceSummaryState sss : serviceSummaryStates) {
            if (!sss.enabled) {
                logger.infoV("Deleting disabled service %s", new Object[]{sss.serviceId});
                this.destroyService(sss.serviceId);
                res.deletedServices.add(sss.serviceId);
                continue;
            }
            servicesToScan.add(sss.serviceId);
        }
        for (String curSrvId : servicesToScan) {
            ServiceManager sm;
            ServiceManager serviceManager = sm = this.getServiceManager(curSrvId);
            synchronized (serviceManager) {
                List<LambdaServiceGenTag.WithStatus> generations = this.getGenerations(curSrvId);
                for (LambdaServiceGenTag.WithStatus gen : generations) {
                    logger.infoV("Analyzing generation of enabled service %s: %s", new Object[]{curSrvId, gen.generationId});
                    if (sm.isGenerationInUse(gen.generationId)) continue;
                    if (sm.hasGenerationActiveQueries(gen.generationId)) {
                        logger.infoV("Generation is not enabled but still has active queries - not deleting", new Object[0]);
                        continue;
                    }
                    logger.infoV("Deleting unused generation %s", new Object[]{gen.generationId});
                    this.destroyGeneration(curSrvId, gen.generationId);
                    res.deletedGenerations.put((Object)curSrvId, (Object)gen.generationId);
                }
            }
        }
        Collections.sort(res.deletedServices);
        return res;
    }

    public synchronized List<ServiceSummaryState> listServices() {
        ArrayList<ServiceSummaryState> ret = new ArrayList<ServiceSummaryState>();
        for (String serviceId : this.serviceManagers.keySet()) {
            try {
                ServiceManager ss;
                ServiceState state = this.readState(serviceId);
                ServiceSummaryState sss = new ServiceSummaryState();
                sss.serviceId = serviceId;
                sss.enabled = state.enabled;
                sss.activeMapping = (GenerationsMapping)JSON.deepCopy((Object)state.activeMapping);
                if (state.enabled && (ss = this.getServiceManager(serviceId)) != null && ss.startAbortedReason != null) {
                    sss.enabled = false;
                    sss.startAbortedReason = ss.startAbortedReason.detailedMessage;
                }
                ret.add(sss);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to read service state: " + serviceId), (Throwable)e);
            }
        }
        return ret;
    }

    public synchronized List<String> listActiveServiceIds() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String serviceId : this.serviceManagers.keySet()) {
            try {
                ServiceManager ss;
                ServiceState state = this.readState(serviceId);
                if (!state.enabled || (ss = this.getServiceManager(serviceId)) == null || ss.startAbortedReason != null) continue;
                ret.add(serviceId);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to read service state: " + serviceId), (Throwable)e);
            }
        }
        return ret;
    }

    private void loadFromPersistentState(String serviceId) throws Exception {
        ServiceState state = this.readState(serviceId);
        logger.infoV("Initial startup of service %s (if needed): %s", new Object[]{serviceId, JSON.log((Object)state)});
        if (state.enabled) {
            if (state.activeMapping == null) {
                throw ErrorContext.iae((String)"Invalid service: enabled but no mapping");
            }
            boolean failed = false;
            try {
                this.setMapping(serviceId, state.activeMapping);
            }
            catch (ServiceManager.ServiceStartAbortedException e) {
                logger.error((Object)"Service start aborted", (Throwable)e);
                ServiceManager sm = this.serviceManagers.get(serviceId);
                Validate.notNull((Object)sm);
                sm.startAbortedReason = new APIError((Throwable)e, true);
                failed = true;
            }
            catch (Exception e) {
                logger.error((Object)"Service start failed, marking it as start-aborted", (Throwable)e);
                ServiceManager sm = this.serviceManagers.get(serviceId);
                Validate.notNull((Object)sm);
                sm.startAbortedReason = new APIError((Throwable)new ServiceManager.ServiceStartAbortedException("Service start failed, maybe need to retrain/redeploy ?", e), true);
                failed = true;
            }
            if (System.getenv("DKU_APINODE_FAIL_IF_START_ABORTED") != null && failed) {
                System.err.println("***************************************************");
                System.err.println("* Service start failed, aborting API Node process *");
                System.err.println("***************************************************");
                System.exit(1);
            }
        } else {
            logger.info((Object)"Service not enabled");
        }
    }

    public ServiceState readState(String serviceId) throws IOException {
        if (this.context.getFile(new String[]{"services", serviceId, "state.json"}).isFile()) {
            return (ServiceState)this.context.parseFile(ServiceState.class, new String[]{"services", serviceId, "state.json"});
        }
        return new ServiceState();
    }

    private void writeState(String serviceId, ServiceState newState) throws IOException {
        File f = this.context.getFile(new String[]{"services", serviceId, "state.json"});
        JSON.prettyToFile((Object)newState, (File)f);
    }

    private void registerService(String serviceName) {
        ServiceManager manager = new ServiceManager(serviceName);
        SpringUtils.getInstance().autowire((Object)manager);
        this.serviceManagers.put(serviceName, manager);
    }

    private void unregisterService(String serviceName) {
        ServiceManager manager = this.serviceManagers.get(serviceName);
        Validate.notNull((Object)manager, (String)("Unknown service: " + serviceName));
        this.serviceManagers.remove(serviceName);
        manager.shutdown();
    }

    public static class ServicesCleanupResponse {
        List<String> deletedServices = new ArrayList<String>();
        TreeMultimap<String, String> deletedGenerations = TreeMultimap.create();

        static {
            JSON.registerAdapter(ServicesCleanupResponse.class, (Object)new ServicesCleanupResponseSerializer());
        }
    }

    public static class ServiceSummaryState {
        public String serviceId;
        boolean enabled;
        GenerationsMapping activeMapping;
        public String startAbortedReason;
    }

    public static class ServicesCleanupResponseSerializer
    implements JSON.Adapter<ServicesCleanupResponse> {
        public ServicesCleanupResponse deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            assert (false) : "Not implemented";
            return null;
        }

        public JsonElement serialize(ServicesCleanupResponse servicesCleanupResponse, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject ret = new JsonObject();
            ret.addProperty("deletedServices", servicesCleanupResponse.deletedServices.toString());
            ret.addProperty("deletedGenerations", servicesCleanupResponse.deletedGenerations.toString());
            return ret;
        }
    }
}

