(function() {
    'use strict';

    const app = angular.module('dataiku.analysis.mlcore');

    app.controller("TimeseriesInteractiveScoringAnalysis", function($scope, PMLSettings, DataikuAPI, PerTimeseriesService, TimeseriesForecastingUtils, FutureProgressModal, $stateParams, Ng2InteractiveScoringScenariosSaveService, LocalStorage, CreateModalFromTemplate, TimeseriesForecastingCustomTrainTestFoldsUtils, $q) {

        $scope.hasExternalFeatures = false;
        $scope.perFeature = {};
        $scope.selectedTimeseriesIdentifier = null;
        $scope.scenariosForecasts = null;
        $scope.isDashboardTile = false;
        $scope.currentMetadata = undefined;

        $scope.dashboardTileView = 'forecasts';
        $scope.toggleView = function() {
            $scope.dashboardTileView = $scope.dashboardTileView === 'forecasts' ? 'scenarios' : 'forecasts';
        }

        $scope.initFilter = function(allUnparsedIdentifiers) {
            const initKey = 'dss.ml.forecastChart.' + $scope.objectId + '.filters';
            $scope.allUnparsedIdentifiers = allUnparsedIdentifiers;
            if (allUnparsedIdentifiers.length > 1) {
                $scope.allTimeseriesIdentifierValuesMap = PerTimeseriesService.initTimeseriesIdentifiersValues($scope.modelData.coreParams.timeseriesIdentifiers);
                if (!sessionStorage.getItem(initKey)) {
                    sessionStorage.setItem(initKey, allUnparsedIdentifiers[0]);
                    LocalStorage.set(initKey, JSON.parse(allUnparsedIdentifiers[0]));
                }
                allUnparsedIdentifiers.forEach(function(unparsedTimeseriesIdentifier) {
                    const parsedTimeseriesIdentifier = JSON.parse(unparsedTimeseriesIdentifier);
                    PerTimeseriesService.addIdentifierValues(parsedTimeseriesIdentifier, $scope.modelData.coreParams.timeseriesIdentifiers, $scope.allTimeseriesIdentifierValuesMap);
                });
                PerTimeseriesService.removeDuplicatesAndSortIdentifierValuesForFilterDropdowns($scope.allTimeseriesIdentifierValuesMap);
            } else if ($scope.allUnparsedIdentifiers && $scope.allUnparsedIdentifiers.length == 1) {
                // If there is one identifier we don't rely on the `timeseriesIdentifiersFiltersUpdated` event
                // and we load the data directly.
                $scope.selectedTimeseriesIdentifier = $scope.allUnparsedIdentifiers[0];
                const scenariosPromise = $scope.loadTimeseriesIdentifierScenarios($scope.selectedTimeseriesIdentifier);
                const forecastsPromise = $scope.getScenarioForecasts();
                // Load forecasts and scenarios in parallel.
                $q.all([scenariosPromise, forecastsPromise]).then(function() {
                    $scope.updateDisplayedTimeseries();
                }).catch(setErrorInScope.bind($scope));
            }
        }
        
        const deregister = $scope.$watch('modelData', function() {
            if (!$scope.modelData) return;
            $scope.perFeature = $scope.modelData.preprocessing.per_feature;
            $scope.isDashboardTile = !!$stateParams.dashboardId;
            $scope.objectId = $scope.isDashboardTile ? `insightId.interactiveScoring.${$scope.insight.id}` : `fullModelId.interactiveScoring.${$scope.modelData.fullModelId}`;
            $scope.identifierScenarios = undefined;

            if (Object.values($scope.modelData.preprocessing.per_feature).some(f => f.role === "INPUT")) {
                $scope.hasExternalFeatures = true;
                // Assuming that models supporting external features also support known in advance features
                $scope.algoIncompatibleWithExternalFeatures = TimeseriesForecastingUtils.ALGOS_WITHOUT_EXTERNAL_FEATURES.names.includes($scope.modelData.modeling.algorithm);
                if (!$scope.algoIncompatibleWithExternalFeatures) {
                    DataikuAPI.ml.prediction.getForecasts($scope.modelData.fullModelId)
                        .then(function(res) {
                            $scope.initFilter(Object.keys(res['data']['perTimeseries']))
                        })
                        .catch(setErrorInScope.bind($scope));
                }
            }
            deregister();
        });

        const setStateFromIdentifierScenarios = function(identifierScenarios) {
            $scope.identifierScenarios = identifierScenarios.scenarios;
            $scope.currentMetadata = identifierScenarios.metadata;
        }

        const createDefaultScenario = function() {
            DataikuAPI.ml.prediction.createInteractiveScoringScenario(
                $scope.modelData.fullModelId,
                $scope.selectedTimeseriesIdentifier,
            )
                .then(function (res) {
                    FutureProgressModal.show($scope, res.data, "Creating the default scenario").then(function (result) {
                        if (result) {
                            setStateFromIdentifierScenarios(result)
                        }
                    });
                })
                .catch(setErrorInScope.bind($scope));
        }

        $scope.loadTimeseriesIdentifierScenarios = function(timeseriesIdentifier) {
            return DataikuAPI.ml.prediction.getInteractiveScoringScenario($scope.modelData.fullModelId, timeseriesIdentifier)
                .then(function(res) {
                    setStateFromIdentifierScenarios(res.data);
                })
                .catch((err) => {
                    if (err.status === 404) {
                        createDefaultScenario();
                    } else {
                        setErrorInScope.bind($scope)(err);
                    }
                });
        }

        $scope.computeScenariosForecasts = function() {
            // Call the interactive-scoring-scenarios-save to save changes if needed, then proceed with compute
            Ng2InteractiveScoringScenariosSaveService.triggerSave().then(function(saveSuccess) {
                if (saveSuccess) {
                    DataikuAPI.ml.prediction.computeInteractiveScoringScenario($scope.modelData.fullModelId, $scope.selectedTimeseriesIdentifier)
                        .then(function (res) {
                            FutureProgressModal.show($scope, res.data, "Compute scenarios forecasts").then(function (result) {
                                if (result) {
                                    $scope.scenariosForecasts = result;
                                    $scope.updateDisplayedTimeseries()
                                    $scope.dashboardTileView = 'forecasts';
                                }
                            }).catch(setErrorInScope.bind($scope));
                        }).catch(setErrorInScope.bind($scope));
                }
            }, function(error) {
                setErrorInScope.bind($scope)(error);
            });
        };

        $scope.getScenarioForecasts = function() {
            return DataikuAPI.ml.prediction.getInteractiveScoringForecastsByIdentifier($scope.modelData.fullModelId, $scope.selectedTimeseriesIdentifier)
                .then(function(res) {
                    if (!Object.keys(res.data).length) {
                        $scope.scenariosForecasts = {};
                    } else {
                        $scope.scenariosForecasts = res.data;
                    }
                })
                .catch(setErrorInScope.bind($scope));
        }

        $scope.$on('timeseriesIdentifiersFiltersUpdated', function(event, filters) {
            $scope.updateSelectedIdentifier(filters);
            const scenariosPromise = $scope.loadTimeseriesIdentifierScenarios($scope.selectedTimeseriesIdentifier);
            const forecastsPromise = $scope.getScenarioForecasts();
            // Load forecasts and scenarios in parallel.
            $q.all([scenariosPromise, forecastsPromise]).then(function() {
                $scope.updateDisplayedTimeseries();
            }).catch(setErrorInScope.bind($scope));
        });

        $scope.updateDisplayedTimeseries = function() {
            if (!$scope.scenariosForecasts || !$scope.selectedTimeseriesIdentifier || !$scope.identifierScenarios) {
                $scope.displayedTimeseriesForecasts = undefined;
                return;
            }

            if (!$scope.scenariosForecasts) { // If no scenario -> compute first
                $scope.computeScenariosForecasts();
            }
            $scope.displayedTimeseriesForecasts = $scope.scenariosForecasts;
        };

        $scope.updateSelectedIdentifier = function(filters) {
            if (!$scope.allUnparsedIdentifiers || !$scope.allUnparsedIdentifiers.length) {
                $scope.selectedTimeseriesIdentifier = null;
                return;
            }
        
            if ($scope.allUnparsedIdentifiers.length === 1) {
                $scope.selectedTimeseriesIdentifier = $scope.allUnparsedIdentifiers[0];
                return;
            }
        
            if (!filters || Object.keys(filters).length === 0) {
                $scope.selectedTimeseriesIdentifier = null;
                return;
            }
        
            $scope.selectedTimeseriesIdentifier = $scope.allUnparsedIdentifiers.find(unparsedIdentifier => {
                const parsedIdentifier = JSON.parse(unparsedIdentifier);
                return Object.keys(filters).every(filterKey => {
                    const filterValue = filters[filterKey];
                    return !filterValue || filterValue === parsedIdentifier[filterKey];
                });
            }) || null;
        };

        $scope.onDeletedScenario = function(scenarioId) {
            // Clean the metadata
            const updatedMetadata = angular.copy($scope.currentMetadata);
            delete updatedMetadata.names[scenarioId];
            delete updatedMetadata.colors[scenarioId];
            $scope.currentMetadata = updatedMetadata;

            // Clean scenarios
            const newIdentifierScenarios = angular.copy($scope.identifierScenarios);
            delete newIdentifierScenarios[scenarioId];
            $scope.identifierScenarios = newIdentifierScenarios;

            // Clean forecasts
            const newForecasts = angular.copy($scope.scenariosForecasts);
            delete newForecasts.perScenarios[scenarioId];
            $scope.scenariosForecasts = newForecasts;

            $scope.updateDisplayedTimeseries();
        }

        $scope.onRenamedScenario = function([scenarioId, newName]) {
            // We rename the metadata data only
            const updatedMetadata = angular.copy($scope.currentMetadata);
            updatedMetadata.names[scenarioId] = newName;
            $scope.currentMetadata = updatedMetadata;
        }

        $scope.onAddedScenario = function(identifierScenarios) {
            setStateFromIdentifierScenarios(identifierScenarios);
        }
    });
})();
