(function() {
    'use strict';

    const app = angular.module('dataiku.dashboards');

    app.directive('dashboardExportFormScenario', function(WT1, DashboardPageSectionFormatService, DashboardPageSectionSettingsService, $timeout) {
        return {
            replace: false,
            require: '^form',
            restrict: 'EA',
            scope: {
                params: '<'
            },
            templateUrl: '/templates/dashboards/export-form-scenario.html',
            link: function($scope) {
                WT1.event('dashboard-export-form-displayed', {});

                $scope.selectedDashboard = {};
                $scope.shouldUseDashboardFormatSettings = true;
                $scope.fileFormat = 'PDF';

                $scope.$watch('params.shouldUseDashboardFormatSettings', (shouldUseDashboardFormatSettings) => {
                    if (shouldUseDashboardFormatSettings === undefined || $scope.shouldUseDashboardFormatSettings === shouldUseDashboardFormatSettings) {
                        return;
                    }

                    if (shouldUseDashboardFormatSettings && !!$scope.selectedDashboard.dashboard) {
                        const pageSectionFormat = (
                            DashboardPageSectionSettingsService.parsePageSectionFormat($scope.selectedDashboard.dashboard.object.pageSectionSettings.pageSectionFormat)
                        );

                        $scope.params.exportFormat = {
                            paperSize: pageSectionFormat.formatName,
                            orientation: pageSectionFormat.orientation,
                            fileType: $scope.params.exportFormat.fileType,
                            width: pageSectionFormat.xInPx,
                            height: pageSectionFormat.yInPx
                        };
                    }

                    $scope.shouldUseDashboardFormatSettings = shouldUseDashboardFormatSettings;
                });

                $scope.$watch('params.exportFormat', (exportFormat) => {
                    if (exportFormat === undefined) {
                        return;
                    }

                    if ($scope.fileFormat !== exportFormat.fileType) {
                        $scope.fileFormat = exportFormat.fileType;
                    }

                    if(!exportFormat.paperSize || !exportFormat.orientation || exportFormat == undefined || exportFormat.height == undefined) {
                        return;
                    }

                    const newPageSectionFormat = DashboardPageSectionFormatService.createPageSectionFormat({
                        formatName: exportFormat.paperSize,
                        orientation: exportFormat.orientation,
                        xInPx: exportFormat.width,
                        yInPx: exportFormat.height,
                        dpi: DashboardPageSectionFormatService.DEFAULT_DPI
                    });

                    if (!DashboardPageSectionFormatService.isPageSectionFormatEqual(newPageSectionFormat, $scope.exportFormat)) {
                        $scope.exportFormat = newPageSectionFormat;
                    }
                });


                $scope.$watch('selectedDashboard.dashboard', (newDashboard) => {
                    if (!newDashboard || !$scope.params.shouldUseDashboardFormatSettings) {
                        return;
                    }

                    const pageSectionFormat = (
                        DashboardPageSectionSettingsService.parsePageSectionFormat(newDashboard.object.pageSectionSettings.pageSectionFormat)
                    );

                    $scope.params.exportFormat = {
                        paperSize: pageSectionFormat.formatName,
                        orientation: pageSectionFormat.orientation,
                        fileType: $scope.fileFormat,
                        width: pageSectionFormat.xInPx,
                        height: pageSectionFormat.yInPx
                    };
                });

                $scope.onExportFormUpdated = (dashboardExportFormValue) => {

                    $timeout(() => {

                        const pageSectionFormat = dashboardExportFormValue.pageSectionFormat;
                        if (pageSectionFormat !== undefined) {
                            $scope.params.exportFormat = {
                                paperSize: pageSectionFormat.formatName,
                                orientation: pageSectionFormat.orientation,
                                fileType: dashboardExportFormValue.fileFormat,
                                width: pageSectionFormat.xInPx,
                                height: pageSectionFormat.yInPx
                            };
                        } else {
                            /*
                             * When shouldUseDashboardSettings is true, dashboardExportFormValue.pageSectionFormat is undefined.
                             * We need to manage the fileType update in this case.
                             */
                            $scope.params.exportFormat = {
                                ...$scope.params.exportFormat,
                                fileType: dashboardExportFormValue.fileFormat
                            };
                        }

                        if (dashboardExportFormValue.shouldUseDashboardSettings !== undefined) {
                            $scope.params.shouldUseDashboardFormatSettings = dashboardExportFormValue.shouldUseDashboardSettings;
                        }
                    });
                };
            }
        };
    });
})();
