(function () {
    "use strict";

    app.component("filterConditionsItemsSelector", {
        bindings: {
            options: "<",
            condition: "=",
        },
        template: `
        <!-- basic select has dirty issues with multiple because the values order changes when clicking -->
<!--    <basic-select ng-if="$ctrl.options"-->
<!--                  items="$ctrl.options"-->
<!--                  ng-model="$ctrl.uiItems"-->
<!--                  ng-change="$ctrl.itemsChanged()"-->
<!--                  multiple="true"-->
<!--                  bind-value="value"-->
<!--                  bind-label="label"-->
<!--                  searchable="true"-->
<!--                  placeholder="Nothing selected"-->
<!--                  invalidate-on-ghosts="true"-->
<!--                  ghost-items-tooltip="LLM no longer available. It has been disabled or retired. Choose another LLM or contact your administrator."-->
<!--                  custom-ng-select-class="ng-dropdown-panel&#45;&#45;500 -->
<!--                                          ng-select&#45;&#45;custom-dropdown-height -->
<!--                                          ng-select&#45;&#45;custom-x-overflow-->
<!--                                          ng-select&#45;&#45;custom-reset-default-padding"></basic-select>-->
            <select 
                    dku-bs-select multiple
                    class="condition-operator"
                    ng-model="$ctrl.uiItems"
                    ng-options="op.value as op.label for op in $ctrl.options"
                    ng-change="$ctrl.itemsChanged()"
                    data-live-search="true"
                    required
            />
`,
        controller: function ($scope, $filter, $attrs) {
            const $ctrl = this;

            $ctrl.uiItems = []

            $ctrl.$onInit = function () {
                if ($ctrl.condition.items) {
                    $ctrl.uiItems = $ctrl.toUiItems($ctrl.condition.items);
                    $ctrl.itemsChanged();
                }
            }
            
            $ctrl.itemsChanged = function() {
                if ($ctrl.uiItems) {
                    $ctrl.condition.items = $ctrl.uiItems.map((value) => ({ string: value, num: 0 }))
                } else {
                    $ctrl.condition.items = [];
                }
            }

            $ctrl.toUiItems = function(_options) {
                if (_options) {
                    return _options.map((item) => item.string)
                } else {
                    return [];
                }
            }
        },
    });
})();
