import tensorflow

from dataiku.base.utils import package_is_at_least

if package_is_at_least(tensorflow, "2.2"):
    if package_is_at_least(tensorflow, "2.14"):
        import tensorflow.python.keras.backend as K
        set_session = K.set_session
    else:
        set_session = tensorflow.compat.v1.keras.backend.set_session
    keras_load_model = tensorflow.keras.models.load_model
    pad_sequences = tensorflow.keras.preprocessing.sequence.pad_sequences
    text = tensorflow.keras.preprocessing.text
    eval = tensorflow.keras.backend.eval
    get_loss = tensorflow.keras.losses.get
    Session = tensorflow.compat.v1.Session
    ConfigProto = tensorflow.compat.v1.ConfigProto
    Sequence = tensorflow.keras.utils.Sequence
    Callback = tensorflow.keras.callbacks.Callback
    optimizers = tensorflow.keras.optimizers
else:
    import keras
    set_session = keras.backend.tensorflow_backend.set_session
    keras_load_model = keras.models.load_model
    pad_sequences = keras.preprocessing.sequence.pad_sequences
    text = keras.preprocessing.text
    eval = keras.backend.eval
    get_loss = keras.losses.get
    Session = tensorflow.Session
    ConfigProto = tensorflow.ConfigProto
    Sequence = keras.utils.Sequence
    Callback = keras.callbacks.Callback
    optimizers = keras.optimizers
