import os

from typing import TYPE_CHECKING

should_mock_types = True

# Debug/test: force mocking types
if os.environ.get("J2PY_DISABLE_TYPING_EXT"):
    should_mock_types = True
    if os.environ.get("J2PY_DEBUG"):
        print("[J2PY] Use own mock (forced)")
else:
    # Check if typing_extensions is installed with version >= 4.3.0
    try:
        from typing import Generic as _Generic, TypeVar as _TypeVar
        from typing_extensions import TypedDict as _TypedDict
        T = _TypeVar("T")
        class A(_Generic[T], _TypedDict):
            pass
        should_mock_types = False
        if os.environ.get("J2PY_DEBUG"):
            print("[J2PY] Use typing_extensions (test passing)")
    except Exception:
        should_mock_types = True
        if os.environ.get("J2PY_DEBUG"):
            print("[J2PY] Use own mock (test failing)")

# Type checkers can't do complex evaluations. We override it so we can import the "real" types
if TYPE_CHECKING:
    from typing_extensions import TypedDict, Literal, Final, NotRequired
else:
    if should_mock_types:
        from .typing_mocks import TypedDict, Literal, Final, NotRequired
    else:
        from typing_extensions import TypedDict, Literal, Final, NotRequired
