from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...llm.online.llm_client.completion_settings import CompletionSettings, _CompletionSettings
from .blocks_graph_block import BlocksGraphBlock, _BlocksGraphBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$ContextCompressionBlock
Via: com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
'''


class _ContextCompressionBlock(_BlocksGraphBlock, TypedDict):
    type: Literal["CONTEXT_COMPRESSION"]
    activeBufferSize: int
    appliesToGenerated: bool
    appliesToInitial: bool
    completionSettings: 'CompletionSettings'
    compressionTriggerChars: int
    llmId: str
    nextBlock: str


ContextCompressionBlock = _ContextCompressionBlock


# EOF
