from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..isotonic_curve.isotonic_curve import IsotonicCurve, _IsotonicCurve
    from ..polynomial_curve.polynomial_curve import PolynomialCurve, _PolynomialCurve
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.curves.Curve
Via: com.dataiku.dip.eda.compute.computations.bivariate.FitCurve
'''


class _Curve(_ImmutableValueObject, TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.eda.compute.curves.Curve
Curve = Union[
    'IsotonicCurve',
    'PolynomialCurve',
]

# Types of class com.dataiku.dip.eda.compute.curves.Curve in PolyJSON mappings (as literal type)
CurveTypeLiteral = Literal["isotonic", "polynomial", ]


# EOF
