<#macro display artifact><@compress single_line=true>
<#if artifact.name??>
    ${artifact.name?truncate(80)}
<#else>
    ${artifact.id} [not authorized]
</#if>
</@compress></#macro>

<#macro link artifact>
<#if ghUrl??>
    <#assign artifactLink = "${ghUrl}/artifact/${artifact.id}">
</#if>
<#if artifactLink??><a href=${artifactLink} target="_blank"></#if><#nested><#if artifactLink??></a></#if>
</#macro>

<#macro breadcrumb artifact>
<#if artifact.breadcrumb??>
<#assign formattedBreadcrumb = []>
<#list artifact.breadcrumb as bcArtifact>
    <#if ghUrl??>
        <#assign artifactLink = "${ghUrl}/bcArtifact/${bcArtifact.id}">
    </#if>
    <#assign formattedArtifact>
        <@artifact_utils.link bcArtifact><@display bcArtifact /></@artifact_utils.link>
    </#assign>
    <#assign formattedBreadcrumb = formattedBreadcrumb + [formattedArtifact]>
    <#if !(bcArtifact.parent??)>
        <#break>
    </#if>
</#list>
<@compress single_line=true>${formattedBreadcrumb?reverse?join(" > ")}</@compress>
</#if>
</#macro>
