DROP FUNCTION jsonb_element_to_jsonb_array_or_empty(JSONB);

CREATE FUNCTION jsonb_element_to_jsonb_array_or_array_containing_null(input_element JSONB)
RETURNS JSONB
LANGUAGE plpgsql AS
$$
BEGIN
    IF input_element IS NULL OR jsonb_typeof(input_element) = 'null' THEN
        RETURN '[null]'::JSONB;
    ELSIF jsonb_typeof(input_element) = 'array' THEN
        IF jsonb_array_length(input_element) = 0 THEN
            RETURN '[null]'::JSONB;
        ELSE
            RETURN input_element;
        END IF;
    ELSE
        RETURN jsonb_build_array(input_element);
    END IF;
END;
$$;
