from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..timeseries.stl_decomposition.decomposition_type import DecompositionType
    from ..timeseries.stl_decomposition.degree_mode import DegreeMode
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.computations.STLDecompositionParams
Via: com.dataiku.dip.eda.compute.computations.timeseries.STLDecomposition
'''


class _STLDecompositionParams(_ImmutableValueObject, TypedDict):
    decompositionType: 'DecompositionType'
    lowPass: NotRequired[Optional[int]]
    lowPassDeg: 'DegreeMode'
    lowPassJump: int
    period: NotRequired[Optional[int]]
    robust: bool
    seasonal: int
    seasonalDeg: 'DegreeMode'
    seasonalJump: int
    showSummary: bool
    trend: NotRequired[Optional[int]]
    trendDeg: 'DegreeMode'
    trendJump: int


STLDecompositionParams = _STLDecompositionParams


# EOF
