from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..pairwise_levene_test.pairwise_levene_test_result import PairwiseLeveneTestResult, _PairwiseLeveneTestResult
    from ..pairwise_mood_test.pairwise_mood_test_result import PairwiseMoodTestResult, _PairwiseMoodTestResult
    from ..pairwise_t_test.pairwise_t_test_result import PairwiseTTestResult, _PairwiseTTestResult
from ...available_result.available_result import AvailableResult, _AvailableResult

'''
Translated from class com.dataiku.dip.eda.compute.computations.univariate.PairwiseTestResult
Via: PyModel annotation in the class hierarchy
'''


class _PairwiseTestResult(_AvailableResult, TypedDict):
    adjustedPvalues: List[float]
    pvalues: List[float]
    statistics: List[float]


# List of all concrete subclasses of com.dataiku.dip.eda.compute.computations.univariate.PairwiseTestResult
PairwiseTestResult = Union[
    'PairwiseLeveneTestResult',
    'PairwiseMoodTestResult',
    'PairwiseTTestResult',
]

# Types of class com.dataiku.dip.eda.compute.computations.univariate.PairwiseTestResult in PolyJSON mappings (as literal type)
PairwiseTestResultTypeLiteral = Literal["pairwise_levene_test", "pairwise_mood_test", "pairwise_ttest", ]


# EOF
